/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.net.URI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.fcrepo.camel.FcrepoComponent;
import org.fcrepo.camel.FcrepoConfiguration;
import org.fcrepo.camel.FcrepoProducer;
import org.fcrepo.camel.FcrepoTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@ManagedResource(description="Managed FcrepoEndpoint")
@UriEndpoint(scheme="fcrepo", title="Fedora Commons Repository", syntax="fcrepo:host:port/path")
public class FcrepoEndpoint
extends DefaultEndpoint {
    private FcrepoConfiguration configuration;
    private PlatformTransactionManager transactionManager;
    public static final int DEFAULT_HTTPS_PORT = 443;

    public FcrepoEndpoint(String uri, String remaining, FcrepoComponent component, FcrepoConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.transactionManager = component.getTransactionManager();
        this.setBaseUrl(remaining);
    }

    public Producer createProducer() {
        return new FcrepoProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new RuntimeCamelException("Cannot consume from a FcrepoEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    public TransactionTemplate createTransactionTemplate() {
        TransactionTemplate transactionTemplate;
        if (this.getTransactionManager() != null) {
            transactionTemplate = new TransactionTemplate(this.getTransactionManager());
        } else {
            FcrepoTransactionManager txMgr = new FcrepoTransactionManager();
            txMgr.setBaseUrl(this.getBaseUrlWithScheme());
            txMgr.setAuthUsername(this.getAuthUsername());
            txMgr.setAuthPassword(this.getAuthPassword());
            txMgr.setAuthHost(this.getAuthHost());
            transactionTemplate = new TransactionTemplate((PlatformTransactionManager)txMgr);
        }
        transactionTemplate.setPropagationBehavior(0);
        transactionTemplate.afterPropertiesSet();
        return transactionTemplate;
    }

    public String getBaseUrlWithScheme() {
        StringBuilder url = new StringBuilder();
        String baseUrl = this.getBaseUrl();
        if (!baseUrl.startsWith("http:") && !baseUrl.startsWith("https:")) {
            if (URI.create("http://" + baseUrl).getPort() == 443) {
                url.append("https://");
            } else {
                url.append("http://");
            }
        }
        url.append(baseUrl);
        return url.toString();
    }

    public FcrepoConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(FcrepoConfiguration config) {
        this.configuration = config;
    }

    public void setBaseUrl(String url) {
        this.getConfiguration().setBaseUrl(url);
    }

    public String getBaseUrl() {
        return this.getConfiguration().getBaseUrl();
    }

    @ManagedAttribute(description="Transaction Manager")
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @ManagedAttribute(description="Transaction Manager")
    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @ManagedAttribute(description="Accept: Header")
    public void setAccept(String type) {
        this.getConfiguration().setAccept(type.replaceAll(" ", "+"));
    }

    @ManagedAttribute(description="Accept: Header")
    public String getAccept() {
        return this.getConfiguration().getAccept();
    }

    @ManagedAttribute(description="Content-Type: Header")
    public void setContentType(String type) {
        this.getConfiguration().setContentType(type);
    }

    @ManagedAttribute(description="Content-Type: Header")
    public String getContentType() {
        return this.getConfiguration().getContentType();
    }

    @ManagedAttribute(description="Username for authentication")
    public void setAuthUsername(String username) {
        this.getConfiguration().setAuthUsername(username);
    }

    @ManagedAttribute(description="Username for authentication")
    public String getAuthUsername() {
        return this.getConfiguration().getAuthUsername();
    }

    @ManagedAttribute(description="Password for authentication")
    public void setAuthPassword(String password) {
        this.getConfiguration().setAuthPassword(password);
    }

    @ManagedAttribute(description="Password for authentication")
    public String getAuthPassword() {
        return this.getConfiguration().getAuthPassword();
    }

    @ManagedAttribute(description="Hostname for authentication")
    public void setAuthHost(String host) {
        this.getConfiguration().setAuthHost(host);
    }

    @ManagedAttribute(description="Hostname for authentication")
    public String getAuthHost() {
        return this.getConfiguration().getAuthHost();
    }

    @ManagedAttribute(description="Whether to retrieve the /fcr:metadata endpoint for Binary nodes")
    public void setMetadata(Boolean metadata) {
        this.getConfiguration().setMetadata(metadata);
    }

    @ManagedAttribute(description="Whether to retrieve the /fcr:metadata endpoint for Binary nodes")
    public Boolean getMetadata() {
        return this.getConfiguration().getMetadata();
    }

    @ManagedAttribute(description="Whether HTTP response errors should throw an exception")
    public void setThrowExceptionOnFailure(Boolean throwOnFailure) {
        this.getConfiguration().setThrowExceptionOnFailure(throwOnFailure);
    }

    @ManagedAttribute(description="Whether HTTP response errors should throw an exception")
    public Boolean getThrowExceptionOnFailure() {
        return this.getConfiguration().getThrowExceptionOnFailure();
    }

    @ManagedAttribute(description="The LDPath transform program to use")
    public void setTransform(String transform) {
        this.getConfiguration().setTransform(transform);
    }

    @ManagedAttribute(description="The LDPath transform program to use")
    public String getTransform() {
        return this.getConfiguration().getTransform();
    }

    @ManagedAttribute(description="Whether to access the /fcr:fixity endpoint for a resource")
    public void setFixity(Boolean fixity) {
        this.getConfiguration().setFixity(fixity);
    }

    @ManagedAttribute(description="Whether to access the /fcr:fixity endpoint for a resource")
    public Boolean getFixity() {
        return this.getConfiguration().getFixity();
    }

    @ManagedAttribute(description="Whether to use the /fcr:tombstone endpoint on objects")
    public void setTombstone(Boolean tombstone) {
        this.getConfiguration().setTombstone(tombstone);
    }

    @ManagedAttribute(description="Whether to use the /fcr:tombstone endpoint on objects")
    public Boolean getTombstone() {
        return this.getConfiguration().getTombstone();
    }

    @ManagedAttribute(description="Whether to include a Prefer: return=representation; include=\"URI\" header")
    public void setPreferInclude(String include) {
        this.getConfiguration().setPreferInclude(include);
    }

    @ManagedAttribute(description="Whether to include a Prefer: return=representation; include=\"URI\" header")
    public String getPreferInclude() {
        return this.getConfiguration().getPreferInclude();
    }

    @ManagedAttribute(description="Whether to include a Prefer: return=representation; omit=\"URI\" header")
    public void setPreferOmit(String omit) {
        this.getConfiguration().setPreferOmit(omit);
    }

    @ManagedAttribute(description="Whether to include a Prefer: return=representation; omit=\"URI\" header")
    public String getPreferOmit() {
        return this.getConfiguration().getPreferOmit();
    }
}

