/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fcrepo.camel.processor.ProcessorUtils;

public class SparqlDeleteProcessor
implements Processor {
    public void process(Exchange exchange) throws IOException {
        Message in = exchange.getIn();
        String namedGraph = (String)in.getHeader("CamelFcrepoNamedGraph", String.class);
        String subject = ProcessorUtils.getSubjectUri(in);
        StringBuilder query = new StringBuilder();
        query.append(ProcessorUtils.deleteWhere(subject, namedGraph));
        query.append(";\n");
        query.append(ProcessorUtils.deleteWhere(subject + "/fcr:export?format=jcr/xml", namedGraph));
        in.setBody((Object)("update=" + URLEncoder.encode(query.toString(), "UTF-8")));
        in.setHeader("CamelHttpMethod", (Object)"POST");
        in.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded; charset=utf-8");
    }
}

