/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fcrepo.camel.processor.ProcessorUtils;

public class SparqlInsertProcessor
implements Processor {
    public void process(Exchange exchange) throws IOException {
        Message in = exchange.getIn();
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        String subject = ProcessorUtils.getSubjectUri(in);
        String namedGraph = (String)in.getHeader("CamelFcrepoNamedGraph", String.class);
        Model model = ModelFactory.createDefaultModel().read((InputStream)in.getBody(InputStream.class), subject, ProcessorUtils.langFromMimeType((String)in.getHeader("Content-Type", String.class)));
        model.write((OutputStream)serializedGraph, "N-TRIPLE");
        exchange.getIn().setBody((Object)("update=" + URLEncoder.encode(ProcessorUtils.insertData(serializedGraph.toString("UTF-8"), namedGraph), "UTF-8")));
        exchange.getIn().setHeader("CamelHttpMethod", (Object)"POST");
        exchange.getIn().setHeader("Content-Type", (Object)"application/x-www-form-urlencoded; charset=utf-8");
    }
}

