/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.camel.FcrepoEndpoint;
import org.fcrepo.camel.FcrepoTransactionObject;
import org.fcrepo.camel.RdfNamespaces;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.FcrepoResponse;
import org.fcrepo.client.HttpMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class FcrepoProducer
extends DefaultProducer {
    public static final String DEFAULT_CONTENT_TYPE = "application/rdf+xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoProducer.class);
    private FcrepoEndpoint endpoint;
    private FcrepoClient client;
    private TransactionTemplate transactionTemplate;

    public FcrepoProducer(FcrepoEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.transactionTemplate = endpoint.createTransactionTemplate();
        this.client = new FcrepoClient(endpoint.getAuthUsername(), endpoint.getAuthPassword(), endpoint.getAuthHost(), endpoint.getThrowExceptionOnFailure());
    }

    public void process(final Exchange exchange) throws FcrepoOperationFailedException {
        if (exchange.isTransacted()) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    DefaultTransactionStatus st = (DefaultTransactionStatus)status;
                    FcrepoTransactionObject tx = (FcrepoTransactionObject)st.getTransaction();
                    try {
                        FcrepoProducer.this.doRequest(exchange, tx.getSessionId());
                    }
                    catch (FcrepoOperationFailedException ex) {
                        throw new TransactionSystemException("Error executing fcrepo request in transaction: ", (Throwable)ex);
                    }
                }
            });
        } else {
            this.doRequest(exchange, null);
        }
    }

    private void doRequest(Exchange exchange, String transaction) throws FcrepoOperationFailedException {
        FcrepoResponse response;
        Message in = exchange.getIn();
        HttpMethods method = this.getMethod(exchange);
        String contentType = this.getContentType(exchange);
        String accept = this.getAccept(exchange);
        String url = this.getUrl(exchange, transaction);
        String prefer = this.getPrefer(exchange);
        LOGGER.debug("Fcrepo Request [{}] with method [{}]", (Object)url, (Object)method);
        switch (method) {
            case PATCH: {
                response = this.client.patch(this.getMetadataUri(url), (InputStream)in.getBody(InputStream.class));
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case PUT: {
                response = this.client.put(URI.create(url), (InputStream)in.getBody(InputStream.class), contentType);
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case POST: {
                response = this.client.post(URI.create(url), (InputStream)in.getBody(InputStream.class), contentType);
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case DELETE: {
                response = this.client.delete(URI.create(url));
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case HEAD: {
                response = this.client.head(URI.create(url));
                exchange.getIn().setBody(null);
                break;
            }
            default: {
                response = this.endpoint.getFixity() != false ? this.client.get(URI.create(url + "/fcr:fixity"), accept, prefer) : (this.endpoint.getMetadata() != false ? this.client.get(this.getMetadataUri(url), accept, prefer) : this.client.get(URI.create(url), accept, prefer));
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
            }
        }
        exchange.getIn().setHeader("Content-Type", (Object)response.getContentType());
        exchange.getIn().setHeader("CamelHttpResponseCode", (Object)response.getStatusCode());
    }

    private URI getMetadataUri(String url) throws FcrepoOperationFailedException {
        FcrepoResponse headResponse = this.client.head(URI.create(url));
        if (headResponse.getLocation() != null) {
            return headResponse.getLocation();
        }
        return URI.create(url);
    }

    private HttpMethods getMethod(Exchange exchange) {
        HttpMethods method = (HttpMethods)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class);
        if (method == null) {
            return HttpMethods.GET;
        }
        return method;
    }

    private String getContentType(Exchange exchange) {
        String contentTypeString = ExchangeHelper.getContentType((Exchange)exchange);
        if (!StringUtils.isBlank((CharSequence)this.endpoint.getContentType())) {
            return this.endpoint.getContentType();
        }
        if (!StringUtils.isBlank((CharSequence)contentTypeString)) {
            return contentTypeString;
        }
        return null;
    }

    private String getAccept(Exchange exchange) {
        Message in = exchange.getIn();
        String fcrepoTransform = (String)in.getHeader("CamelFcrepoTransform", String.class);
        String acceptHeader = this.getAcceptHeader(exchange);
        if (!StringUtils.isBlank((CharSequence)this.endpoint.getTransform()) || !StringUtils.isBlank((CharSequence)fcrepoTransform)) {
            return "application/json";
        }
        if (!StringUtils.isBlank((CharSequence)this.endpoint.getAccept())) {
            return this.endpoint.getAccept();
        }
        if (!StringUtils.isBlank((CharSequence)acceptHeader)) {
            return acceptHeader;
        }
        if (!this.endpoint.getMetadata().booleanValue()) {
            return "*/*";
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private String getAcceptHeader(Exchange exchange) {
        Message in = exchange.getIn();
        if (!StringUtils.isBlank((CharSequence)((CharSequence)in.getHeader("CamelAcceptContentType", String.class)))) {
            return (String)in.getHeader("CamelAcceptContentType", String.class);
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)in.getHeader("Accept", String.class)))) {
            return (String)in.getHeader("Accept", String.class);
        }
        return null;
    }

    private String getPathFromHeaders(Exchange exchange) {
        Message in = exchange.getIn();
        if (!StringUtils.isBlank((CharSequence)((CharSequence)in.getHeader("CamelFcrepoIdentifier", String.class)))) {
            return (String)in.getHeader("CamelFcrepoIdentifier", String.class);
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)in.getHeader("org.fcrepo.jms.identifier", String.class)))) {
            return (String)in.getHeader("org.fcrepo.jms.identifier", String.class);
        }
        return "";
    }

    private String getTransformPath(Exchange exchange) {
        Message in = exchange.getIn();
        HttpMethods method = this.getMethod(exchange);
        String transformProgram = (String)in.getHeader("CamelFcrepoTransform", String.class);
        String fcrTransform = "/fcr:transform";
        if (!StringUtils.isBlank((CharSequence)this.endpoint.getTransform()) || !StringUtils.isBlank((CharSequence)transformProgram)) {
            LOGGER.warn("The transform option for fcrepo-camel has been deprecated and will be removed in 4.5.0");
            if (method == HttpMethods.POST) {
                return "/fcr:transform";
            }
            if (method == HttpMethods.GET) {
                if (!StringUtils.isBlank((CharSequence)transformProgram)) {
                    return "/fcr:transform/" + transformProgram;
                }
                return "/fcr:transform/" + this.endpoint.getTransform();
            }
        }
        return "";
    }

    private String getUrl(Exchange exchange, String transaction) {
        StringBuilder url = new StringBuilder();
        String transformPath = this.getTransformPath(exchange);
        HttpMethods method = this.getMethod(exchange);
        url.append(this.endpoint.getBaseUrlWithScheme());
        if (transaction != null) {
            url.append("/");
            url.append(transaction);
        }
        url.append(this.getPathFromHeaders(exchange));
        if (!StringUtils.isBlank((CharSequence)transformPath)) {
            url.append(transformPath);
        } else if (method == HttpMethods.DELETE && this.endpoint.getTombstone().booleanValue()) {
            LOGGER.warn("The tombstone option is deprecated and will be removed in the 4.5.0 release of fcrepo-camel");
            url.append("/fcr:tombstone");
        }
        return url.toString();
    }

    private String getPrefer(Exchange exchange) {
        Message in = exchange.getIn();
        if (this.getMethod(exchange) == HttpMethods.GET) {
            if (!StringUtils.isBlank((CharSequence)((CharSequence)in.getHeader("CamelFcrepoPrefer", String.class)))) {
                return (String)in.getHeader("CamelFcrepoPrefer", String.class);
            }
            return this.buildPreferHeader(this.endpoint.getPreferInclude(), this.endpoint.getPreferOmit());
        }
        return null;
    }

    private String buildPreferHeader(String include, String omit) {
        if (StringUtils.isBlank((CharSequence)include) && StringUtils.isBlank((CharSequence)omit)) {
            return null;
        }
        StringBuilder prefer = new StringBuilder("return=representation;");
        if (!StringUtils.isBlank((CharSequence)include)) {
            prefer.append(" include=\"" + this.addPreferNamespace(include) + "\";");
        }
        if (!StringUtils.isBlank((CharSequence)omit)) {
            prefer.append(" omit=\"" + this.addPreferNamespace(omit) + "\";");
        }
        LOGGER.info("Prefer: {}", (Object)prefer.toString());
        return prefer.toString();
    }

    private String addPreferNamespace(String property) {
        String prefer = RdfNamespaces.PREFER_PROPERTIES.get(property);
        if (!StringUtils.isBlank((CharSequence)prefer)) {
            return prefer;
        }
        return property;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object extractResponseBodyAsStream(InputStream is, Exchange exchange) {
        if (is == null) {
            return null;
        }
        if (((Boolean)exchange.getProperty("CamelDisableHttpStreamCache", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return is;
        }
        try (CachedOutputStream cos = new CachedOutputStream(exchange);){
            IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)cos);
            StreamCache streamCache = cos.newStreamCache();
            return streamCache;
        }
        catch (IOException ex) {
            LOGGER.debug("Error extracting body from http request", (Throwable)ex);
            return null;
        }
    }
}

