/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoPrefer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoPrefer.class);
    private static final String LINK_DELIM = "\\s*;\\s*";
    private static final String OMIT = "omit";
    private static final String INCLUDE = "include";
    private String returnType = null;
    private List<URI> omit;
    private List<URI> include;

    public FcrepoPrefer(String prefer) {
        this.parse(prefer);
    }

    public boolean isMinimal() {
        return this.returnType != null && this.returnType.equals("minimal");
    }

    public boolean isRepresentation() {
        return this.returnType != null && this.returnType.equals("representation");
    }

    public List<URI> getOmit() {
        return this.omit;
    }

    public List<URI> getInclude() {
        return this.include;
    }

    private void parse(String prefer) {
        if (prefer != null) {
            HashMap<String, String> data = new HashMap<String, String>();
            for (String section : prefer.split(LINK_DELIM)) {
                String[] parts = section.split("=");
                if (parts.length != 2) continue;
                String value = parts[1].startsWith("\"") && parts[1].endsWith("\"") ? parts[1].substring(1, parts[1].length() - 1) : parts[1];
                data.put(parts[0], value);
            }
            this.returnType = (String)data.get("return");
            this.include = this.getUris((String)data.get(INCLUDE));
            this.omit = this.getUris((String)data.get(OMIT));
        } else {
            LOGGER.warn("Could not parse a null Prefer value");
        }
    }

    private List<URI> getUris(String uris) {
        if (uris != null) {
            return Arrays.stream(uris.split("\\s+")).filter(uri -> uri.length() > 0).map(URI::create).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

