/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.camel.FcrepoEndpoint;
import org.fcrepo.camel.FcrepoPrefer;
import org.fcrepo.camel.FcrepoTransactionObject;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.FcrepoResponse;
import org.fcrepo.client.GetBuilder;
import org.fcrepo.client.HttpMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class FcrepoProducer
extends DefaultProducer {
    public static final String DEFAULT_CONTENT_TYPE = "application/rdf+xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoProducer.class);
    private static final String LDP = "http://www.w3.org/ns/ldp#";
    private static final String REPOSITORY = "http://fedora.info/definitions/v4/repository#";
    private FcrepoEndpoint endpoint;
    private FcrepoClient fcrepoClient;
    private TransactionTemplate transactionTemplate;
    public static final Map<String, String> PREFER_PROPERTIES;
    private static Function<String, String> addPreferNamespace;

    public FcrepoProducer(FcrepoEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.transactionTemplate = endpoint.createTransactionTemplate();
        FcrepoClient.FcrepoClientBuilder builder = FcrepoClient.client().credentials(endpoint.getAuthUsername(), endpoint.getAuthPassword()).authScope(endpoint.getAuthHost());
        this.fcrepoClient = endpoint.getThrowExceptionOnFailure() != false ? builder.throwExceptionOnFailure().build() : builder.build();
    }

    public void process(final Exchange exchange) throws FcrepoOperationFailedException {
        if (exchange.isTransacted()) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    DefaultTransactionStatus st = (DefaultTransactionStatus)status;
                    FcrepoTransactionObject tx = (FcrepoTransactionObject)st.getTransaction();
                    try {
                        FcrepoProducer.this.doRequest(exchange, tx.getSessionId());
                    }
                    catch (FcrepoOperationFailedException ex) {
                        throw new TransactionSystemException("Error executing fcrepo request in transaction: ", (Throwable)ex);
                    }
                }
            });
        } else {
            this.doRequest(exchange, null);
        }
    }

    private void doRequest(Exchange exchange, String transaction) throws FcrepoOperationFailedException {
        FcrepoResponse response;
        Message in = exchange.getIn();
        HttpMethods method = this.getMethod(exchange);
        String contentType = this.getContentType(exchange);
        String accept = this.getAccept(exchange);
        String url = this.getUrl(exchange, transaction);
        LOGGER.debug("Fcrepo Request [{}] with method [{}]", (Object)url, (Object)method);
        switch (method) {
            case PATCH: {
                response = this.fcrepoClient.patch(this.getMetadataUri(url)).body((InputStream)in.getBody(InputStream.class)).perform();
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case PUT: {
                response = this.fcrepoClient.put(URI.create(url)).body((InputStream)in.getBody(InputStream.class), contentType).perform();
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case POST: {
                response = this.fcrepoClient.post(URI.create(url)).body((InputStream)in.getBody(InputStream.class), contentType).perform();
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case DELETE: {
                response = this.fcrepoClient.delete(URI.create(url)).perform();
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case HEAD: {
                response = this.fcrepoClient.head(URI.create(url)).perform();
                exchange.getIn().setBody(null);
                break;
            }
            default: {
                GetBuilder get = this.fcrepoClient.get(this.getUri(this.endpoint, url)).accept(accept);
                String preferHeader = (String)in.getHeader("CamelFcrepoPrefer", (Object)"", String.class);
                if (!preferHeader.isEmpty()) {
                    FcrepoPrefer prefer = new FcrepoPrefer(preferHeader);
                    response = prefer.isMinimal() ? get.preferMinimal().perform() : (prefer.isRepresentation() ? get.preferRepresentation(prefer.getInclude(), prefer.getOmit()).perform() : get.perform());
                } else {
                    List<URI> include = this.getPreferInclude(this.endpoint);
                    List<URI> omit = this.getPreferOmit(this.endpoint);
                    response = include.isEmpty() && omit.isEmpty() ? get.perform() : get.preferRepresentation(include, omit).perform();
                }
                exchange.getIn().setBody(FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
            }
        }
        exchange.getIn().setHeader("Content-Type", (Object)response.getContentType());
        exchange.getIn().setHeader("CamelHttpResponseCode", (Object)response.getStatusCode());
    }

    private URI getUri(FcrepoEndpoint endpoint, String url) throws FcrepoOperationFailedException {
        if (endpoint.getFixity().booleanValue()) {
            return URI.create(url + "/fcr:fixity");
        }
        if (endpoint.getMetadata().booleanValue()) {
            return this.getMetadataUri(url);
        }
        return URI.create(url);
    }

    private List<URI> getPreferOmit(FcrepoEndpoint endpoint) {
        if (!StringUtils.isBlank((CharSequence)endpoint.getPreferOmit())) {
            return Arrays.stream(endpoint.getPreferOmit().split("\\s+")).map(addPreferNamespace).map(URI::create).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<URI> getPreferInclude(FcrepoEndpoint endpoint) {
        if (!StringUtils.isBlank((CharSequence)endpoint.getPreferInclude())) {
            return Arrays.stream(endpoint.getPreferInclude().split("\\s+")).map(addPreferNamespace).map(URI::create).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private URI getMetadataUri(String url) throws FcrepoOperationFailedException {
        FcrepoResponse headResponse = this.fcrepoClient.head(URI.create(url)).perform();
        if (headResponse.getLocation() != null) {
            return headResponse.getLocation();
        }
        return URI.create(url);
    }

    private HttpMethods getMethod(Exchange exchange) {
        HttpMethods method = (HttpMethods)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class);
        if (method == null) {
            return HttpMethods.GET;
        }
        return method;
    }

    private String getContentType(Exchange exchange) {
        String contentTypeString = ExchangeHelper.getContentType((Exchange)exchange);
        if (!StringUtils.isBlank((CharSequence)this.endpoint.getContentType())) {
            return this.endpoint.getContentType();
        }
        if (!StringUtils.isBlank((CharSequence)contentTypeString)) {
            return contentTypeString;
        }
        return null;
    }

    private String getAccept(Exchange exchange) {
        String acceptHeader = this.getAcceptHeader(exchange);
        if (!StringUtils.isBlank((CharSequence)this.endpoint.getAccept())) {
            return this.endpoint.getAccept();
        }
        if (!StringUtils.isBlank((CharSequence)acceptHeader)) {
            return acceptHeader;
        }
        if (!this.endpoint.getMetadata().booleanValue()) {
            return "*/*";
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private String getAcceptHeader(Exchange exchange) {
        Message in = exchange.getIn();
        if (!StringUtils.isBlank((CharSequence)((CharSequence)in.getHeader("CamelAcceptContentType", String.class)))) {
            return (String)in.getHeader("CamelAcceptContentType", String.class);
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)in.getHeader("Accept", String.class)))) {
            return (String)in.getHeader("Accept", String.class);
        }
        return null;
    }

    private String getUrl(Exchange exchange, String transaction) {
        String uri = (String)exchange.getIn().getHeader("CamelFcrepoUri", (Object)"", String.class);
        if (!uri.isEmpty()) {
            return uri;
        }
        String baseUrl = (String)exchange.getIn().getHeader("CamelFcrepoBaseUrl", (Object)"", String.class);
        StringBuilder url = new StringBuilder(baseUrl.isEmpty() ? this.endpoint.getBaseUrlWithScheme() : baseUrl);
        if (transaction != null) {
            url.append("/");
            url.append(transaction);
        }
        url.append((String)exchange.getIn().getHeader("CamelFcrepoIdentifier", (Object)"", String.class));
        return url.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object extractResponseBodyAsStream(InputStream is, Exchange exchange) {
        if (is == null) {
            return null;
        }
        if (((Boolean)exchange.getProperty("CamelDisableHttpStreamCache", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return is;
        }
        try (CachedOutputStream cos = new CachedOutputStream(exchange);){
            IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)cos);
            StreamCache streamCache = cos.newStreamCache();
            return streamCache;
        }
        catch (IOException ex) {
            LOGGER.debug("Error extracting body from http request", (Throwable)ex);
            return null;
        }
    }

    static {
        HashMap<String, String> prefer = new HashMap<String, String>();
        prefer.put("PreferContainment", "http://www.w3.org/ns/ldp#PreferContainment");
        prefer.put("PreferMembership", "http://www.w3.org/ns/ldp#PreferMembership");
        prefer.put("PreferMinimalContainer", "http://www.w3.org/ns/ldp#PreferMinimalContainer");
        prefer.put("ServerManaged", "http://fedora.info/definitions/v4/repository#ServerManaged");
        prefer.put("EmbedResources", "http://fedora.info/definitions/v4/repository#EmbedResources");
        prefer.put("InboundReferences", "http://fedora.info/definitions/v4/repository#InboundReferences");
        PREFER_PROPERTIES = Collections.unmodifiableMap(prefer);
        addPreferNamespace = property -> {
            String prefer = PREFER_PROPERTIES.get(property);
            if (!StringUtils.isBlank((CharSequence)prefer)) {
                return prefer;
            }
            return property;
        };
    }
}

