/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.io.InputStream;
import java.net.URI;
import org.fcrepo.camel.FcrepoTransactionObject;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.FcrepoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class FcrepoTransactionManager
extends AbstractPlatformTransactionManager {
    private FcrepoClient fcrepoClient;
    private String baseUrl;
    private String authUsername;
    private String authPassword;
    private String authHost;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoTransactionManager.class);

    public FcrepoTransactionManager() {
        this.setNestedTransactionAllowed(false);
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setAuthUsername(String authUsername) {
        this.authUsername = authUsername;
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        InputStream is = null;
        String contentType = null;
        FcrepoTransactionObject tx = (FcrepoTransactionObject)transaction;
        if (tx.getSessionId() == null) {
            FcrepoResponse response;
            try {
                response = this.getClient().post(URI.create(this.baseUrl + "/fcr:tx")).body(is, contentType).perform();
            }
            catch (FcrepoOperationFailedException ex) {
                LOGGER.debug("HTTP Operation failed: ", (Throwable)ex);
                throw new CannotCreateTransactionException("Could not create fcrepo transaction");
            }
            if (response != null && response.getLocation() != null) {
                tx.setSessionId(response.getLocation().toString().substring(this.baseUrl.length() + 1));
            } else {
                throw new CannotCreateTransactionException("Invalid response while creating transaction");
            }
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        FcrepoTransactionObject tx = (FcrepoTransactionObject)status.getTransaction();
        InputStream is = null;
        String contentType = null;
        try {
            this.getClient().post(URI.create(this.baseUrl + "/" + tx.getSessionId() + "/fcr:tx/fcr:commit")).body(is, contentType).perform();
        }
        catch (FcrepoOperationFailedException ex) {
            LOGGER.debug("Transaction commit failed: ", (Throwable)ex);
            throw new TransactionSystemException("Could not commit fcrepo transaction");
        }
        finally {
            tx.setSessionId(null);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        FcrepoTransactionObject tx = (FcrepoTransactionObject)status.getTransaction();
        try {
            this.getClient().post(URI.create(this.baseUrl + "/" + tx.getSessionId() + "/fcr:tx/fcr:rollback")).perform();
        }
        catch (FcrepoOperationFailedException ex) {
            LOGGER.debug("Transaction rollback failed: ", (Throwable)ex);
            throw new TransactionSystemException("Could not rollback fcrepo transaction");
        }
        finally {
            tx.setSessionId(null);
        }
    }

    protected Object doGetTransaction() {
        return new FcrepoTransactionObject();
    }

    private FcrepoClient getClient() {
        if (this.fcrepoClient == null) {
            return FcrepoClient.client().credentials(this.authUsername, this.authPassword).authScope(this.authHost).throwExceptionOnFailure().build();
        }
        return this.fcrepoClient;
    }
}

