/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class EventProcessor
implements Processor {
    private static final ObjectMapper mapper = new ObjectMapper();

    public void process(Exchange exchange) throws IOException {
        Object body = exchange.getIn().getBody();
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        if (body != null) {
            if (body instanceof Map) {
                data.putAll(EventProcessor.getValuesFromMap((Map)body));
            } else if (body instanceof String) {
                data.putAll(this.getValuesFromJson(mapper.readTree((String)body)));
            } else if (body instanceof InputStream) {
                data.putAll(this.getValuesFromJson(mapper.readTree((InputStream)body)));
            }
        }
        HashSet<String> singleValuedFields = new HashSet<String>();
        singleValuedFields.add("CamelFcrepoUri");
        singleValuedFields.add("CamelFcrepoDateTime");
        singleValuedFields.add("CamelFcrepoEventId");
        data.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> !((List)entry.getValue()).isEmpty()).forEach(entry -> {
            if (singleValuedFields.contains(entry.getKey())) {
                exchange.getIn().setHeader((String)entry.getKey(), ((List)entry.getValue()).get(0));
            } else {
                exchange.getIn().setHeader((String)entry.getKey(), entry.getValue());
            }
        });
    }

    private Map<String, List<String>> getValuesFromJson(JsonNode body) {
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        EventProcessor.getValues(body, "@id").ifPresent(id -> data.put("CamelFcrepoUri", (List<String>)id));
        EventProcessor.getValues(body, "id").ifPresent(id -> data.putIfAbsent("CamelFcrepoUri", (List<String>)id));
        EventProcessor.getValues(body, "@type").ifPresent(type -> data.put("CamelFcrepoResourceType", (List<String>)type));
        EventProcessor.getValues(body, "type").ifPresent(type -> data.putIfAbsent("CamelFcrepoResourceType", (List<String>)type));
        if (body.has("wasGeneratedBy")) {
            JsonNode generatedBy = body.get("wasGeneratedBy");
            EventProcessor.getValues(generatedBy, "type").ifPresent(type -> data.put("CamelFcrepoEventType", (List<String>)type));
            EventProcessor.getValues(generatedBy, "atTime").ifPresent(time -> data.put("CamelFcrepoDateTime", (List<String>)time));
            EventProcessor.getValues(generatedBy, "identifier").ifPresent(id -> data.put("CamelFcrepoEventId", (List<String>)id));
        }
        if (body.has("wasAttributedTo")) {
            JsonNode attributedTo = body.get("wasAttributedTo");
            if (attributedTo.isArray()) {
                ArrayList agents = new ArrayList();
                for (JsonNode agent : attributedTo) {
                    EventProcessor.getString(agent, "name").ifPresent(agents::add);
                }
                data.put("CamelFcrepoAgent", agents);
            } else {
                EventProcessor.getString(attributedTo, "name").ifPresent(name -> data.put("CamelFcrepoAgent", Collections.singletonList(name)));
            }
        }
        return data;
    }

    private static Optional<String> getString(JsonNode node, String fieldName) {
        JsonNode field;
        if (node.has(fieldName) && (field = node.get(fieldName)).isTextual()) {
            return Optional.of(field.asText());
        }
        return Optional.empty();
    }

    private static Optional<List<String>> getValues(JsonNode node, String fieldName) {
        if (node.has(fieldName)) {
            JsonNode field = node.get(fieldName);
            if (field.isArray()) {
                ArrayList elements = new ArrayList();
                field.elements().forEachRemaining(elem -> {
                    if (elem.isTextual()) {
                        elements.add(elem.asText());
                    }
                });
                return Optional.of(elements);
            }
            if (field.isTextual()) {
                return Optional.of(Collections.singletonList(field.asText()));
            }
        }
        return Optional.empty();
    }

    private static Map<String, List<String>> getValuesFromMap(Map body) {
        List wasAttributedTo;
        Map wasGeneratedBy;
        Map values = body;
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        if (values.containsKey("@id")) {
            data.put("CamelFcrepoUri", Collections.singletonList((String)values.get("@id")));
        }
        if (values.containsKey("id")) {
            data.putIfAbsent("CamelFcrepoUri", Collections.singletonList((String)values.get("id")));
        }
        if (values.containsKey("@type")) {
            data.put("CamelFcrepoResourceType", (List)values.get("@type"));
        }
        if (values.containsKey("type")) {
            data.putIfAbsent("CamelFcrepoResourceType", (List)values.get("type"));
        }
        if ((wasGeneratedBy = (Map)values.get("wasGeneratedBy")) != null) {
            if (wasGeneratedBy.containsKey("type")) {
                data.put("CamelFcrepoEventType", (List)wasGeneratedBy.get("type"));
            }
            data.put("CamelFcrepoEventId", Collections.singletonList((String)wasGeneratedBy.get("identifier")));
            data.put("CamelFcrepoDateTime", Collections.singletonList((String)wasGeneratedBy.get("atTime")));
        }
        if ((wasAttributedTo = (List)values.get("wasAttributedTo")) != null) {
            data.put("CamelFcrepoAgent", wasAttributedTo.stream().map(agent -> (String)agent.get("name")).collect(Collectors.toList()));
        }
        return data;
    }
}

