/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.http.entity.ContentType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.fcrepo.camel.processor.ProcessorUtils;

public class LdnProcessor
implements Processor {
    private static final String PROV = "http://www.w3.org/ns/prov#";
    private static final Property wasAssociatedWith = ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#wasAssociatedWith");
    private static final Property wasAttributedTo = ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#wasAttributedTo");
    private static final Property wasGeneratedBy = ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#wasGeneratedBy");
    private static final Property used = ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#used");

    public void process(Exchange exchange) throws IOException, NoSuchHeaderException {
        Message in = exchange.getIn();
        Model model = ModelFactory.createDefaultModel();
        Model newModel = ModelFactory.createDefaultModel();
        Resource resource = ResourceFactory.createResource((String)ProcessorUtils.getSubjectUri(exchange));
        Resource event = ResourceFactory.createResource((String)"");
        AtomicInteger counter = new AtomicInteger();
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        RDFDataMgr.read((Model)model, (InputStream)((InputStream)in.getBody(InputStream.class)), (Lang)RDFLanguages.contentTypeToLang((String)ContentType.parse((String)((String)in.getHeader("Content-Type", String.class))).getMimeType()));
        newModel.add(ResourceFactory.createStatement((Resource)event, (Property)used, (RDFNode)resource));
        model.listObjectsOfProperty(resource, wasGeneratedBy).forEachRemaining(obj -> {
            if (obj.isResource()) {
                obj.asResource().listProperties().forEachRemaining(stmt -> newModel.add(ResourceFactory.createStatement((Resource)event, (Property)stmt.getPredicate(), (RDFNode)stmt.getObject())));
            }
        });
        model.listObjectsOfProperty(resource, wasAttributedTo).forEachRemaining(obj -> {
            Resource agent = ResourceFactory.createResource((String)("#agent" + Integer.toString(counter.getAndIncrement())));
            if (obj.isResource()) {
                obj.asResource().listProperties().forEachRemaining(stmt -> newModel.add(ResourceFactory.createStatement((Resource)agent, (Property)stmt.getPredicate(), (RDFNode)stmt.getObject())));
            }
            newModel.add(ResourceFactory.createStatement((Resource)event, (Property)wasAssociatedWith, (RDFNode)agent));
        });
        RDFDataMgr.write((OutputStream)serializedGraph, (Model)newModel, (RDFFormat)RDFFormat.JSONLD);
        in.setBody((Object)serializedGraph.toString("UTF-8"));
        in.setHeader("CamelHttpMethod", (Object)"POST");
        in.setHeader("Content-Type", (Object)"application/ld+json");
    }
}

