/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ActivityStreamTerms {
    Accept,
    Activity,
    IntransitiveActivity,
    Add,
    Announce,
    Application,
    Arrive,
    Article,
    Audio,
    Block,
    Collection,
    CollectionPage,
    Relationship,
    Create,
    Delete,
    Dislike,
    Document,
    Event,
    Follow,
    Flag,
    Group,
    Ignore,
    Image,
    Invite,
    Join,
    Leave,
    Like,
    Link,
    Mention,
    Note,
    Object,
    Offer,
    OrderedCollection,
    OrderedCollectionPage,
    Organization,
    Page,
    Person,
    Place,
    Profile,
    Question,
    Reject,
    Remove,
    Service,
    TentativeAccept,
    TentativeReject,
    Tombstone,
    Undo,
    Update,
    Video,
    View,
    Listen,
    Read,
    Move,
    Travel,
    IsFollowing,
    IsFollowedBy,
    IsContact,
    IsMember;

    public static final String ACTIVITY_STREAMS_BASEURI = "https://www.w3.org/ns/activitystreams#";
    private static Map<String, String> terms;

    public URI asUri() {
        return URI.create(ACTIVITY_STREAMS_BASEURI + this.toString());
    }

    public static String expand(String term) {
        return Optional.ofNullable(terms.get(term)).orElse(term);
    }

    static {
        terms = Arrays.asList(ActivityStreamTerms.values()).stream().map(Objects::toString).collect(Collectors.toMap(Function.identity(), t -> ACTIVITY_STREAMS_BASEURI + t));
    }
}

