/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.fcrepo.camel.processor.ActivityStreamTerms;

public class EventProcessor
implements Processor {
    private static final ObjectMapper mapper = new ObjectMapper();

    public void process(Exchange exchange) throws IOException {
        Object body = exchange.getIn().getBody();
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        if (body != null) {
            if (body instanceof Map) {
                data.putAll(EventProcessor.getValuesFromMap((Map)body));
            } else if (body instanceof String) {
                data.putAll(this.getValuesFromJson(mapper.readTree((String)body)));
            } else if (body instanceof InputStream) {
                data.putAll(this.getValuesFromJson(mapper.readTree((InputStream)body)));
            }
        }
        HashSet<String> singleValuedFields = new HashSet<String>();
        singleValuedFields.add("CamelFcrepoUri");
        singleValuedFields.add("CamelFcrepoDateTime");
        singleValuedFields.add("CamelFcrepoEventId");
        data.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> !((List)entry.getValue()).isEmpty()).forEach(entry -> {
            if (singleValuedFields.contains(entry.getKey())) {
                exchange.getIn().setHeader((String)entry.getKey(), ((List)entry.getValue()).get(0));
            } else {
                exchange.getIn().setHeader((String)entry.getKey(), entry.getValue());
            }
        });
    }

    private Map<String, List<String>> getValuesFromJson(JsonNode body) {
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        EventProcessor.getValues(body, "@id").ifPresent(id -> data.put("CamelFcrepoEventId", (List<String>)id));
        EventProcessor.getValues(body, "id").ifPresent(id -> data.putIfAbsent("CamelFcrepoEventId", (List<String>)id));
        EventProcessor.getValues(body, "published").ifPresent(date -> data.putIfAbsent("CamelFcrepoDateTime", (List<String>)date));
        EventProcessor.getValues(body, "type").map(EventProcessor::toUris).ifPresent(type -> data.put("CamelFcrepoEventType", (List<String>)type));
        if (body.has("object")) {
            JsonNode object = body.get("object");
            EventProcessor.getValues(object, "@id").ifPresent(id -> data.put("CamelFcrepoUri", (List<String>)id));
            EventProcessor.getValues(object, "id").ifPresent(id -> data.putIfAbsent("CamelFcrepoUri", (List<String>)id));
            EventProcessor.getValues(object, "@type").ifPresent(type -> data.put("CamelFcrepoResourceType", (List<String>)type));
            EventProcessor.getValues(object, "type").ifPresent(type -> data.putIfAbsent("CamelFcrepoResourceType", (List<String>)type));
        }
        if (body.has("actor")) {
            JsonNode actor = body.get("actor");
            if (actor.isArray()) {
                ArrayList agents = new ArrayList();
                for (JsonNode agent : actor) {
                    EventProcessor.getString(agent, "name").ifPresent(agents::add);
                    EventProcessor.getString(agent, "id").ifPresent(agents::add);
                }
                data.put("CamelFcrepoAgent", agents);
            } else {
                EventProcessor.getString(actor, "name").ifPresent(name -> data.put("CamelFcrepoAgent", Collections.singletonList(name)));
                EventProcessor.getString(actor, "id").ifPresent(name -> data.put("CamelFcrepoAgent", Collections.singletonList(name)));
            }
        }
        return data;
    }

    private static List<String> toUris(List<String> jsonldValues) {
        return jsonldValues.stream().map(ActivityStreamTerms::expand).collect(Collectors.toList());
    }

    private static Optional<String> getString(JsonNode node, String fieldName) {
        JsonNode field;
        if (node.has(fieldName) && (field = node.get(fieldName)).isTextual()) {
            return Optional.of(field.asText());
        }
        return Optional.empty();
    }

    private static Optional<List<String>> getValues(JsonNode node, String fieldName) {
        if (node.has(fieldName)) {
            JsonNode field = node.get(fieldName);
            if (field.isArray()) {
                ArrayList elements = new ArrayList();
                field.elements().forEachRemaining(elem -> {
                    if (elem.isTextual()) {
                        elements.add(elem.asText());
                    }
                });
                return Optional.of(elements);
            }
            if (field.isTextual()) {
                return Optional.of(Collections.singletonList(field.asText()));
            }
        }
        return Optional.empty();
    }

    private static Map<String, List<String>> getValuesFromMap(Map body) {
        List actor;
        Map object;
        Map values = body;
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        if (values.containsKey("@id")) {
            data.put("CamelFcrepoEventId", Collections.singletonList((String)values.get("@id")));
        }
        if (values.containsKey("id")) {
            data.putIfAbsent("CamelFcrepoEventId", Collections.singletonList((String)values.get("id")));
        }
        if (values.containsKey("@type")) {
            data.put("CamelFcrepoEventType", EventProcessor.toUris((List)values.get("@type")));
        }
        if (values.containsKey("type")) {
            data.putIfAbsent("CamelFcrepoEventType", EventProcessor.toUris((List)values.get("type")));
        }
        if (values.containsKey("published")) {
            data.putIfAbsent("CamelFcrepoDateTime", Collections.singletonList((String)values.get("published")));
        }
        if ((object = (Map)values.get("object")) != null) {
            if (object.containsKey("type")) {
                data.put("CamelFcrepoResourceType", (List)object.get("type"));
            }
            data.put("CamelFcrepoUri", Collections.singletonList((String)object.get("id")));
        }
        if ((actor = (List)values.get("actor")) != null) {
            data.put("CamelFcrepoAgent", actor.stream().map(agent -> (String)Optional.ofNullable(agent.get("name")).orElse(agent.get("id"))).collect(Collectors.toList()));
        }
        return data;
    }
}

