/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.util.ExchangeHelper;
import org.apache.jena.util.URIref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorUtils.class);

    private ProcessorUtils() {
    }

    private static String trimTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getSubjectUri(Exchange exchange) throws NoSuchHeaderException {
        String uri = (String)exchange.getIn().getHeader("CamelFcrepoUri", (Object)"", String.class);
        if (uri.isEmpty()) {
            String base = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelFcrepoBaseUrl", String.class);
            String path = (String)exchange.getIn().getHeader("CamelFcrepoIdentifier", (Object)"", String.class);
            return ProcessorUtils.trimTrailingSlash(base) + path;
        }
        return uri;
    }

    public static String deleteWhere(String subject, String namedGraph) {
        StringBuilder stmt = new StringBuilder("DELETE WHERE { ");
        if (!namedGraph.isEmpty()) {
            stmt.append("GRAPH ");
            stmt.append("<" + URIref.encode((String)namedGraph) + ">");
            stmt.append(" { ");
        }
        stmt.append("<" + URIref.encode((String)subject) + ">");
        stmt.append(" ?p ?o ");
        if (!namedGraph.isEmpty()) {
            stmt.append("} ");
        }
        stmt.append("}");
        return stmt.toString();
    }

    public static String insertData(String serializedGraph, String namedGraph) {
        StringBuilder query = new StringBuilder("INSERT DATA { ");
        if (!namedGraph.isEmpty()) {
            query.append("GRAPH <");
            query.append(URIref.encode((String)namedGraph));
            query.append("> { ");
        }
        query.append(serializedGraph);
        if (!namedGraph.isEmpty()) {
            query.append("} ");
        }
        query.append("}");
        return query.toString();
    }

    public static List<String> tokenizePropertyPlaceholder(CamelContext context, String property, String token) {
        try {
            return Arrays.stream(context.resolvePropertyPlaceholders(property).split(token)).map(String::trim).filter(val -> !val.isEmpty()).collect(Collectors.toList());
        }
        catch (Exception ex) {
            LOGGER.debug("No property value found for {}", (Object)property);
            return Collections.emptyList();
        }
    }
}

