/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.http.entity.ContentType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.fcrepo.camel.processor.ProcessorUtils;

public class SparqlUpdateProcessor
implements Processor {
    public void process(Exchange exchange) throws IOException, NoSuchHeaderException {
        Message in = exchange.getIn();
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        String namedGraph = (String)in.getHeader("CamelFcrepoNamedGraph", (Object)"", String.class);
        Model model = ModelFactory.createDefaultModel();
        String subject = ProcessorUtils.getSubjectUri(exchange);
        RDFDataMgr.read((Model)model, (InputStream)((InputStream)in.getBody(InputStream.class)), (Lang)RDFLanguages.contentTypeToLang((String)ContentType.parse((String)((String)in.getHeader("Content-Type", String.class))).getMimeType()));
        model.write((OutputStream)serializedGraph, "N-TRIPLE");
        in.setBody((Object)("update=" + URLEncoder.encode(ProcessorUtils.deleteWhere(subject, namedGraph) + ";\n" + ProcessorUtils.insertData(serializedGraph.toString("UTF-8"), namedGraph), "UTF-8")));
        in.setHeader("CamelHttpMethod", (Object)"POST");
        in.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded; charset=utf-8");
    }
}

