/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.fixity;

import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixityRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixityRouter.class);

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.add("premis", "http://www.loc.gov/premis/rdf/v1#");
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)((ExpressionNode)((FilterDefinition)((RouteDefinition)this.from("{{fixity.stream}}").routeId("FcrepoFixity").to("fcrepo:{{fcrepo.baseUrl}}?preferInclude=ServerManged&accept=application/rdf+xml")).filter().xpath("/rdf:RDF/rdf:Description/rdf:type[@rdf:resource='http://fedora.info/definitions/v4/repository#Binary']", ns)).log(LoggingLevel.INFO, LOGGER, "Checking Fixity for ${headers[CamelFcrepoIdentifier]}")).delay((Expression)this.simple("{{fixity.delay}}")).to("fcrepo:{{fcrepo.baseUrl}}?fixity=true&accept=application/rdf+xml")).choice().when().xpath("/rdf:RDF/rdf:Description/premis:hasEventOutcome[text()='SUCCESS']", ns)).to("{{fixity.success}}")).otherwise().log(LoggingLevel.WARN, LOGGER, "Fixity error on ${headers[CamelFcrepoIdentifier]}")).to("{{fixity.failure}}");
    }
}

