/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.fixity;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpComponent;
import org.fcrepo.camel.common.config.BasePropsConfig;
import org.fcrepo.camel.common.config.ConditionOnPropertyTrue;
import org.fcrepo.camel.fixity.FixityRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={FixityEnabled.class})
public class FcrepoFixityConfig
extends BasePropsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoFixityConfig.class);
    static final String FIXITY_ENABLED = "fixity.enabled";
    @Value(value="${fixity.input.stream:broker:queue:fixity}")
    private String inputStream;
    @Value(value="${fixity.delay:0}")
    private long fixityDelay;
    @Value(value="${fixity.failure:file:/tmp/?fileName=fixityErrors.log&fileExist=Append}")
    private String fixityFailure;
    @Value(value="${fixity.success:mock:fixity.success}")
    private String fixitySuccess;

    public String getInputStream() {
        return this.inputStream;
    }

    public long getFixityDelay() {
        return this.fixityDelay;
    }

    public String getFixitySuccess() {
        return this.fixitySuccess;
    }

    public String getFixityFailure() {
        return this.fixityFailure;
    }

    @Bean(name={"http"})
    public HttpComponent http() {
        return new HttpComponent();
    }

    @Bean(name={"https"})
    public HttpComponent https() {
        return new HttpComponent();
    }

    @Bean
    public RouteBuilder fixityRoute() {
        return new FixityRouter();
    }

    static class FixityEnabled
    extends ConditionOnPropertyTrue {
        FixityEnabled() {
            super(FcrepoFixityConfig.FIXITY_ENABLED, false);
        }
    }
}

