/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.fixity;

import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.fcrepo.camel.fixity.FcrepoFixityConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FixityRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixityRouter.class);
    private static final String REPOSITORY = "http://fedora.info/definitions/v4/repository#";
    @Autowired
    private FcrepoFixityConfig config;

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.add("premis", "http://www.loc.gov/premis/rdf/v1#");
        this.onException(Exception.class).maximumRedeliveries(this.config.getMaxRedeliveries()).log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)((ExpressionNode)((FilterDefinition)((RouteDefinition)this.from(this.config.getInputStream()).routeId("FcrepoFixity").to("fcrepo:" + this.config.getFcrepoBaseUrl() + "?preferInclude=ServerManged&accept=application/rdf+xml")).filter().xpath("/rdf:RDF/rdf:Description/rdf:type[@rdf:resource='http://fedora.info/definitions/v4/repository#Binary']", ns)).log(LoggingLevel.INFO, LOGGER, "Checking Fixity for ${headers[CamelFcrepoUri]}")).delay((Expression)this.simple(String.valueOf(this.config.getFixityDelay()))).to("fcrepo:" + this.config.getFcrepoBaseUrl() + "?fixity=true&accept=application/rdf+xml")).choice().when().xpath("/rdf:RDF/rdf:Description/premis:hasEventOutcome[text()='SUCCESS']", ns)).log(LoggingLevel.INFO, LOGGER, "Fixity success on ${headers[CamelFcrepoUri]}")).to(this.config.getFixitySuccess())).otherwise().log(LoggingLevel.WARN, LOGGER, "Fixity error on ${headers[CamelFcrepoUri]}")).to(this.config.getFixityFailure());
        LOGGER.info("FixityRouter configured");
    }
}

