/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.httpforwarding;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpComponent;
import org.fcrepo.camel.common.config.BasePropsConfig;
import org.fcrepo.camel.common.config.ConditionOnPropertyTrue;
import org.fcrepo.camel.httpforwarding.HttpRouter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={HttpForwardingingEnabled.class})
public class FcrepoHttpForwardingConfig
extends BasePropsConfig {
    static final String HTTP_FORWARDING_ENABLED = "http.enabled";
    @Value(value="${http.input.stream:broker:topic:fedora}")
    private String inputStream;
    @Value(value="${http.reindex.stream:broker:queue:http.reindex}")
    private String reindexStream;
    @Value(value="${http.filter.containers:http://localhost:8080/fcrepo/rest/audit}")
    private String filterContainers;
    @Value(value="${http.baseUrl:}")
    private String httpBaseUrl;
    @Value(value="${http.authUsername:}")
    private String httpAuthUsername;
    @Value(value="${http.authPassword:}")
    private String httpAuthPassword;

    public String getInputStream() {
        return this.inputStream;
    }

    public String getReindexStream() {
        return this.reindexStream;
    }

    public String getFilterContainers() {
        return this.filterContainers;
    }

    public String getHttpBaseUrl() {
        return this.httpBaseUrl;
    }

    public String getHttpAuthUsername() {
        return this.httpAuthUsername;
    }

    public String getHttpAuthPassword() {
        return this.httpAuthPassword;
    }

    @Bean(name={"http"})
    public HttpComponent http() {
        return new HttpComponent();
    }

    @Bean(name={"https"})
    public HttpComponent https() {
        return new HttpComponent();
    }

    @Bean
    public RouteBuilder httpRoute() {
        return new HttpRouter();
    }

    static class HttpForwardingingEnabled
    extends ConditionOnPropertyTrue {
        HttpForwardingingEnabled() {
            super(FcrepoHttpForwardingConfig.HTTP_FORWARDING_ENABLED, false);
        }
    }
}

