/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.httpforwarding;

import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.fcrepo.camel.common.processor.AddBasicAuthProcessor;
import org.fcrepo.camel.httpforwarding.FcrepoHttpForwardingConfig;
import org.fcrepo.camel.processor.EventProcessor;
import org.fcrepo.camel.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HttpRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRouter.class);
    @Autowired
    private FcrepoHttpForwardingConfig config;

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.add("indexing", "http://fedora.info/definitions/v4/indexing#");
        ns.add("ldp", "http://www.w3.org/ns/ldp#");
        this.onException(Exception.class).maximumRedeliveries(this.config.getMaxRedeliveries()).log("Index Routing Error: ${routeId}");
        ((RouteDefinition)((RouteDefinition)this.from(this.config.getInputStream()).routeId("FcrepoHttpRouter").process((Processor)new EventProcessor())).log(LoggingLevel.TRACE, "Received message from Fedora routing to index.http")).to("direct:add.type.to.http.message");
        this.from(this.config.getReindexStream()).routeId("FcrepoHttpReindex").to("direct:add.type.to.http.message");
        ((ProcessorDefinition)((ChoiceDefinition)((ProcessorDefinition)this.from("direct:add.type.to.http.message").routeId("FcrepoHttpAddType").choice().when((Predicate)this.simple("${header.org.fcrepo.jms.eventtype}")).setHeader("CamelFcrepoEventType").simple("${header.org.fcrepo.jms.eventtype}")).to("direct:send.to.http")).otherwise().setHeader("CamelFcrepoEventType").constant((Object)"https://www.w3.org/ns/activitystreams#Update")).to("direct:send.to.http");
        ((ExpressionNode)((ProcessorDefinition)((ProcessorDefinition)((ExpressionNode)((ExpressionNode)this.from("direct:send.to.http").routeId("FcrepoHttpSend").filter(PredicateBuilder.not((Predicate)PredicateBuilder.in(ProcessorUtils.tokenizePropertyPlaceholder((CamelContext)this.getContext(), (String)this.config.getFilterContainers(), (String)",").stream().map(uri -> PredicateBuilder.or((Predicate)this.header("CamelFcrepoUri").startsWith((Object)this.constant(uri + "/")), (Predicate)this.header("CamelFcrepoUri").isEqualTo((Object)this.constant(uri)))).collect(Collectors.toList())))).log(LoggingLevel.INFO, LOGGER, "sending ${headers[CamelFcrepoUri]} to http endpoint...")).to("mustache:org/fcrepo/camel/httpforwarding/httpMessage.mustache")).setHeader("CamelHttpMethod").constant((Object)"POST")).setHeader("Content-Type").constant((Object)"application/json")).process((Processor)new AddBasicAuthProcessor(this.config.getHttpAuthUsername(), this.config.getHttpAuthPassword()))).to(this.config.getHttpBaseUrl().isEmpty() ? "direct:http.baseurl.missing" : this.config.getHttpBaseUrl());
        ((RouteDefinition)this.from("direct:http.baseurl.missing").routeId("FcrepoHttpBaseUrlMissing").log(LoggingLevel.ERROR, LOGGER, "Cannot forward HTTP message because http.baseUrl property is empty.")).stop();
    }
}

