/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.indexing.triplestore;

import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.fcrepo.camel.processor.SparqlDeleteProcessor;
import org.fcrepo.camel.processor.SparqlUpdateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriplestoreRouter
extends RouteBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TriplestoreRouter.class);

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.add("indexing", "http://fedora.info/definitions/v4/indexing#");
        XPathBuilder indexable = new XPathBuilder(String.format("/rdf:RDF/rdf:Description/rdf:type[@rdf:resource='%s']", "http://fedora.info/definitions/v4/indexing#Indexable"));
        indexable.namespaces(ns);
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)this.from("{{input.stream}}").routeId("FcrepoTriplestoreRouter").choice().when(this.header("org.fcrepo.jms.eventType").isEqualTo((Object)"http://fedora.info/definitions/v4/repository#NODE_REMOVED")).to("direct:delete.triplestore")).otherwise().to("direct:index.triplestore");
        this.from("{{triplestore.reindex.stream}}").routeId("FcrepoTriplestoreReindex").to("direct:index.triplestore");
        ((ChoiceDefinition)((ExpressionNode)((ExpressionNode)this.from("direct:index.triplestore").routeId("FcrepoTriplestoreIndexer").filter(PredicateBuilder.not((Predicate)PredicateBuilder.or((Predicate)this.header("org.fcrepo.jms.identifier").startsWith((Object)this.simple("{{audit.container}}/")), (Predicate)this.header("org.fcrepo.jms.identifier").isEqualTo((Object)this.simple("{{audit.container}}"))))).removeHeaders("CamelHttp*")).to("fcrepo:{{fcrepo.baseUrl}}?preferInclude=PreferMinimalContainer&accept=application/rdf+xml")).choice().when(PredicateBuilder.or((Predicate)this.simple("{{indexing.predicate}} != 'true'"), (Predicate)indexable)).to("direct:update.triplestore")).otherwise().to("direct:delete.triplestore");
        ((RouteDefinition)((RouteDefinition)this.from("direct:delete.triplestore").routeId("FcrepoTriplestoreDeleter").process((Processor)new SparqlDeleteProcessor())).log(LoggingLevel.INFO, logger, "Deleting Triplestore Object ${headers[CamelFcrepoIdentifier]} ${headers[org.fcrepo.jms.identifier]}")).to("http4://{{triplestore.baseUrl}}");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)this.from("direct:update.triplestore").routeId("FcrepoTriplestoreUpdater").setHeader("CamelFcrepoNamedGraph").simple("{{triplestore.namedGraph}}")).to("fcrepo:{{fcrepo.baseUrl}}?accept=application/n-triples&preferOmit={{prefer.omit}}&preferInclude={{prefer.include}}")).process((Processor)new SparqlUpdateProcessor())).log(LoggingLevel.INFO, logger, "Indexing Triplestore Object ${headers[CamelFcrepoIdentifier]} ${headers[org.fcrepo.jms.identifier]}")).to("http4://{{triplestore.baseUrl}}");
    }
}

