/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.indexing.triplestore;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpComponent;
import org.fcrepo.camel.common.config.BasePropsConfig;
import org.fcrepo.camel.common.config.ConditionOnPropertyTrue;
import org.fcrepo.camel.indexing.triplestore.TriplestoreRouter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={TriplestoreIndexingEnabled.class})
public class FcrepoTripleStoreIndexingConfig
extends BasePropsConfig {
    static final String TRIPLESTORE_INDEXING_ENABLED = "triplestore.indexing.enabled";
    @Value(value="${triplestore.input.stream:broker:topic:fedora}")
    private String inputStream;
    @Value(value="${triplestore.reindex.stream:broker:queue:triplestore.reindex}")
    private String reindexStream;
    @Value(value="${triplestore.indexing.predicate:false}")
    private boolean indexingPredicate;
    @Value(value="${triplestore.namedGraph:}")
    private String namedGraph;
    @Value(value="${triplestore.filter.containers:http://localhost:8080/fcrepo/rest/audit}")
    private String filterContainers;
    @Value(value="${triplestore.prefer.include:}")
    private String preferInclude;
    @Value(value="${triplestore.prefer.omit:http://www.w3.org/ns/ldp#PreferContainment}")
    private String preferOmit;
    @Value(value="${triplestore.baseUrl:http://localhost:8080/fuseki/test/update}")
    private String triplestoreBaseUrl;
    @Value(value="${triplestore.authUsername:}")
    private String triplestoreAuthUsername;
    @Value(value="${triplestore.authPassword:}")
    private String triplestoreAuthPassword;

    public String getInputStream() {
        return this.inputStream;
    }

    public String getReindexStream() {
        return this.reindexStream;
    }

    public boolean isIndexingPredicate() {
        return this.indexingPredicate;
    }

    public String getNamedGraph() {
        return this.namedGraph;
    }

    public String getFilterContainers() {
        return this.filterContainers;
    }

    public String getPreferInclude() {
        return this.preferInclude;
    }

    public String getPreferOmit() {
        return this.preferOmit;
    }

    public String getTriplestoreBaseUrl() {
        return this.triplestoreBaseUrl;
    }

    public String getTriplestoreAuthUsername() {
        return this.triplestoreAuthUsername;
    }

    public String getTriplestoreAuthPassword() {
        return this.triplestoreAuthPassword;
    }

    @Bean(name={"http"})
    public HttpComponent http() {
        return new HttpComponent();
    }

    @Bean(name={"https"})
    public HttpComponent https() {
        return new HttpComponent();
    }

    @Bean
    public RouteBuilder tripleStoreRoute() {
        return new TriplestoreRouter();
    }

    static class TriplestoreIndexingEnabled
    extends ConditionOnPropertyTrue {
        TriplestoreIndexingEnabled() {
            super(FcrepoTripleStoreIndexingConfig.TRIPLESTORE_INDEXING_ENABLED, false);
        }
    }
}

