/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.indexing.triplestore;

import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.fcrepo.camel.common.processor.AddBasicAuthProcessor;
import org.fcrepo.camel.indexing.triplestore.FcrepoTripleStoreIndexingConfig;
import org.fcrepo.camel.processor.EventProcessor;
import org.fcrepo.camel.processor.ProcessorUtils;
import org.fcrepo.camel.processor.SparqlDeleteProcessor;
import org.fcrepo.camel.processor.SparqlUpdateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TriplestoreRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriplestoreRouter.class);
    private static final String RESOURCE_DELETION = "http://fedora.info/definitions/v4/event#ResourceDeletion";
    private static final String DELETE = "https://www.w3.org/ns/activitystreams#Delete";
    @Autowired
    private FcrepoTripleStoreIndexingConfig config;

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.add("indexing", "http://fedora.info/definitions/v4/indexing#");
        XPathBuilder indexable = new XPathBuilder(String.format("/rdf:RDF/rdf:Description/rdf:type[@rdf:resource='%s']", "http://fedora.info/definitions/v4/indexing#Indexable"));
        indexable.namespaces(ns);
        this.onException(Exception.class).maximumRedeliveries(this.config.getMaxRedeliveries()).log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from(this.config.getInputStream()).routeId("FcrepoTriplestoreRouter").process((Processor)new EventProcessor())).choice().when(PredicateBuilder.or((Predicate)this.header("CamelFcrepoEventType").contains((Object)RESOURCE_DELETION), (Predicate)this.header("CamelFcrepoEventType").contains((Object)DELETE))).log(LoggingLevel.INFO, "deleting " + this.header("CamelFcrepoUri") + " from triplestore.")).to("direct:delete.triplestore")).otherwise().to("direct:index.triplestore");
        this.from(this.config.getReindexStream()).routeId("FcrepoTriplestoreReindex").to("direct:index.triplestore");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)this.from("direct:index.triplestore").routeId("FcrepoTriplestoreIndexer").filter(PredicateBuilder.not((Predicate)PredicateBuilder.in(ProcessorUtils.tokenizePropertyPlaceholder((CamelContext)this.getContext(), (String)this.config.getFilterContainers(), (String)",").stream().map(uri -> PredicateBuilder.or((Predicate)this.header("CamelFcrepoUri").startsWith((Object)this.constant(uri + "/")), (Predicate)this.header("CamelFcrepoUri").isEqualTo((Object)this.constant(uri)))).collect(Collectors.toList())))).removeHeaders("CamelHttp*")).choice().when((Predicate)this.simple(this.config.isIndexingPredicate() + " != 'true'")).to("direct:update.triplestore")).otherwise().to("fcrepo:" + this.config.getFcrepoBaseUrl() + "?preferInclude=PreferMinimalContainer&accept=application/rdf+xml")).choice().when((Predicate)indexable).to("direct:update.triplestore")).otherwise().to("direct:delete.triplestore");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:delete.triplestore").routeId("FcrepoTriplestoreDeleter").process((Processor)new SparqlDeleteProcessor())).log(LoggingLevel.INFO, LOGGER, "Deleting Triplestore Object ${headers[CamelFcrepoUri]}")).process((Processor)new AddBasicAuthProcessor(this.config.getTriplestoreAuthUsername(), this.config.getTriplestoreAuthPassword()))).to(this.config.getTriplestoreBaseUrl() + "?useSystemProperties=true");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)this.from("direct:update.triplestore").routeId("FcrepoTriplestoreUpdater").setHeader("CamelFcrepoNamedGraph").simple(this.config.getNamedGraph())).to("fcrepo:" + this.config.getFcrepoBaseUrl() + "?accept=application/n-triples&preferOmit=" + this.config.getPreferOmit() + "&preferInclude=" + this.config.getPreferInclude())).process((Processor)new SparqlUpdateProcessor())).log(LoggingLevel.INFO, LOGGER, "Indexing Triplestore Object ${headers[CamelFcrepoUri]}")).process((Processor)new AddBasicAuthProcessor(this.config.getTriplestoreAuthUsername(), this.config.getTriplestoreAuthPassword()))).to(this.config.getTriplestoreBaseUrl() + "?useSystemProperties=true");
    }
}

