/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.SortedSet;
import javolution.lang.Realtime;
import javolution.util.FastCollection;
import javolution.util.FastSet;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.internal.map.sorted.FastSortedMapImpl;
import javolution.util.internal.set.sorted.AtomicSortedSetImpl;
import javolution.util.internal.set.sorted.SharedSortedSetImpl;
import javolution.util.internal.set.sorted.UnmodifiableSortedSetImpl;
import javolution.util.service.SortedSetService;

public class FastSortedSet<E>
extends FastSet<E>
implements SortedSet<E> {
    private static final long serialVersionUID = 1536L;

    public FastSortedSet() {
        this(Equalities.STANDARD);
    }

    public FastSortedSet(Equality<? super E> comparator) {
        super(new FastSortedMapImpl<E, Object>(comparator, Equalities.IDENTITY).keySet());
    }

    protected FastSortedSet(SortedSetService<E> service) {
        super(service);
    }

    @Override
    public FastSortedSet<E> atomic() {
        return new FastSortedSet(new AtomicSortedSetImpl(this.service()));
    }

    @Override
    public FastSortedSet<E> shared() {
        return new FastSortedSet(new SharedSortedSetImpl(this.service()));
    }

    @Override
    public FastSortedSet<E> unmodifiable() {
        return new FastSortedSet(new UnmodifiableSortedSetImpl(this.service()));
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean add(E e) {
        return super.add(e);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean contains(Object obj) {
        return super.contains(obj);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean remove(Object obj) {
        return super.remove(obj);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public FastSortedSet<E> subSet(E fromElement, E toElement) {
        return new FastSortedSet<E>(this.service().subSet(fromElement, toElement));
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public FastSortedSet<E> headSet(E toElement) {
        return this.subSet((Object)this.first(), (Object)toElement);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public FastSortedSet<E> tailSet(E fromElement) {
        return this.subSet((Object)fromElement, (Object)this.last());
    }

    @Override
    public E first() {
        return this.service().first();
    }

    @Override
    public E last() {
        return this.service().last();
    }

    @Override
    public FastSortedSet<E> addAll(E ... elements) {
        return (FastSortedSet)super.addAll((Object[])elements);
    }

    @Override
    public FastSortedSet<E> addAll(FastCollection<? extends E> that) {
        return (FastSortedSet)super.addAll((FastCollection)that);
    }

    @Override
    protected SortedSetService<E> service() {
        return (SortedSetService)super.service();
    }
}

