/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    private HashUtils() {
    }

    public static final String md5sum(String string) {
        return HashUtils.calcHash(string, "MD5");
    }

    public static final String md5sum(File file) throws FileNotFoundException, IOException {
        return HashUtils.calcHash(new FileInputStream(file), "MD5");
    }

    public static final String md5sum(Path file) throws FileNotFoundException, IOException {
        return HashUtils.md5sum(file.toFile());
    }

    public static final String md5sum(InputStream inStream) throws IOException {
        return HashUtils.calcHash(inStream, "MD5");
    }

    public static final String md5sum(byte[] bytes) {
        return HashUtils.calcHash(bytes, "MD5");
    }

    public static final String sha1(String string) {
        return HashUtils.calcHash(string, "SHA-1");
    }

    public static final String sha1(File file) throws FileNotFoundException, IOException {
        return HashUtils.calcHash(new FileInputStream(file), "SHA-1");
    }

    public static final String sha1(Path file) throws FileNotFoundException, IOException {
        return HashUtils.sha1(file.toFile());
    }

    public static final String sha1(InputStream inStream) throws IOException {
        return HashUtils.calcHash(inStream, "SHA-1");
    }

    public static final String sha1(byte[] bytes) {
        return HashUtils.calcHash(bytes, "SHA-1");
    }

    public static final String sha512(String string) {
        return HashUtils.calcHash(string, "SHA-512");
    }

    public static final String sha512(File file) throws FileNotFoundException, IOException {
        return HashUtils.calcHash(new FileInputStream(file), "SHA-512");
    }

    public static final String sha512(Path file) throws FileNotFoundException, IOException {
        return HashUtils.sha512(file.toFile());
    }

    public static final String sha512(InputStream inStream) throws IOException {
        return HashUtils.calcHash(inStream, "SHA-512");
    }

    public static final String sha512(byte[] bytes) {
        return HashUtils.calcHash(bytes, "SHA-512");
    }

    private static String calcHash(String string, String algorithm) {
        try {
            return HashUtils.calcHash(string.getBytes("UTF-8"), algorithm);
        }
        catch (UnsupportedEncodingException e) {
            return HashUtils.calcHash(string.getBytes(), algorithm);
        }
    }

    private static String calcHash(byte[] bytes, String algorithm) {
        try {
            MessageDigest m = MessageDigest.getInstance(algorithm);
            m.update(bytes);
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calcHash(InputStream input, String algorithm) throws IOException {
        String string;
        MessageDigest md = MessageDigest.getInstance(algorithm);
        DigestInputStream dis = new DigestInputStream(input, md);
        try {
            byte[] buff = new byte[4096];
            while (dis.read(buff) > 0) {
            }
            string = new BigInteger(1, md.digest()).toString(16);
        }
        catch (Throwable throwable) {
            try {
                dis.close();
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                return "";
            }
        }
        dis.close();
        return string;
    }
}

