/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.rdf;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.provider.rdf.AbstractRDFProvider;

public class CacheProvider
extends AbstractRDFProvider {
    public static final String PROVIDER_NAME = "LD Cache";

    public String getName() {
        return PROVIDER_NAME;
    }

    public List<String> buildRequestUrl(String resourceUri, Endpoint endpoint) {
        Preconditions.checkNotNull((Object)resourceUri);
        Preconditions.checkNotNull((Object)endpoint);
        try {
            return Collections.singletonList(endpoint.getEndpointUrl().replace("{uri}", URLEncoder.encode(resourceUri, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding UTF-8 not supported; the Java environment is severely broken");
        }
    }
}

