/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.api.functions.TestFunction;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;
import org.apache.marmotta.ldpath.api.tests.NodeTest;
import org.apache.marmotta.ldpath.api.transformers.NodeTransformer;
import org.apache.marmotta.ldpath.model.fields.FieldMapping;
import org.apache.marmotta.ldpath.model.programs.Program;
import org.apache.marmotta.ldpath.model.selectors.FunctionSelector;
import org.apache.marmotta.ldpath.model.selectors.GroupedSelector;
import org.apache.marmotta.ldpath.model.selectors.IntersectionSelector;
import org.apache.marmotta.ldpath.model.selectors.PathSelector;
import org.apache.marmotta.ldpath.model.selectors.PropertySelector;
import org.apache.marmotta.ldpath.model.selectors.RecursivePathSelector;
import org.apache.marmotta.ldpath.model.selectors.ReversePropertySelector;
import org.apache.marmotta.ldpath.model.selectors.SelfSelector;
import org.apache.marmotta.ldpath.model.selectors.StringConstantSelector;
import org.apache.marmotta.ldpath.model.selectors.TestingSelector;
import org.apache.marmotta.ldpath.model.selectors.UnionSelector;
import org.apache.marmotta.ldpath.model.selectors.WildcardSelector;
import org.apache.marmotta.ldpath.model.tests.AndTest;
import org.apache.marmotta.ldpath.model.tests.FunctionTest;
import org.apache.marmotta.ldpath.model.tests.IsATest;
import org.apache.marmotta.ldpath.model.tests.LiteralLanguageTest;
import org.apache.marmotta.ldpath.model.tests.LiteralTypeTest;
import org.apache.marmotta.ldpath.model.tests.NotTest;
import org.apache.marmotta.ldpath.model.tests.OrTest;
import org.apache.marmotta.ldpath.model.tests.PathEqualityTest;
import org.apache.marmotta.ldpath.model.tests.PathTest;
import org.apache.marmotta.ldpath.model.transformers.IdentityTransformer;
import org.apache.marmotta.ldpath.parser.Configuration;
import org.apache.marmotta.ldpath.parser.DefaultConfiguration;
import org.apache.marmotta.ldpath.parser.LdPathParserConstants;
import org.apache.marmotta.ldpath.parser.LdPathParserTokenManager;
import org.apache.marmotta.ldpath.parser.ParseException;
import org.apache.marmotta.ldpath.parser.SimpleCharStream;
import org.apache.marmotta.ldpath.parser.Token;
import org.apache.marmotta.ldpath.parser.TokenMgrError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdPathParser<Node>
implements LdPathParserConstants {
    private static final Logger log = LoggerFactory.getLogger(LdPathParser.class);
    private Map<String, String> namespaces = new HashMap<String, String>();
    private NodeBackend<Node> backend;
    private Configuration config;
    private Mode mode = Mode.PROGRAM;
    private Map<String, NodeTransformer<?, Node>> xsdNodeTransformerMap;
    private Map<String, SelectorFunction<Node>> xsdNodeFunctionMap;
    private Map<String, TestFunction<Node>> xsdNodeTestMap;
    public LdPathParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[68];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public LdPathParser(NodeBackend<Node> backend, Reader in) {
        this(backend, null, in);
    }

    public LdPathParser(NodeBackend<Node> backend, Configuration config, Reader in) {
        this(in);
        this.backend = backend;
        this.config = config == null ? new DefaultConfiguration() : config;
    }

    public LdPathParser(NodeBackend<Node> backend, InputStream in) {
        this(backend, null, in);
    }

    public LdPathParser(NodeBackend<Node> backend, Configuration config, InputStream in) {
        this(in);
        this.backend = backend;
        this.config = config == null ? new DefaultConfiguration() : config;
    }

    public LdPathParser(NodeBackend<Node> backend, InputStream in, String encoding) {
        this(backend, null, in, encoding);
    }

    public LdPathParser(NodeBackend<Node> backend, Configuration config, InputStream in, String encoding) {
        this(in, encoding);
        this.backend = backend;
        this.config = config == null ? new DefaultConfiguration() : config;
    }

    public Program<Node> parseProgram() throws ParseException {
        this.namespaces.clear();
        this.namespaces.putAll(this.config.getNamespaces());
        this.mode = Mode.PROGRAM;
        try {
            return this.Program();
        }
        catch (TokenMgrError error) {
            throw new ParseException("Unable to parse Program: (Message: " + error.getMessage() + ")");
        }
    }

    public Map.Entry<String, String> parsePrefix() throws ParseException {
        this.namespaces.clear();
        this.namespaces.putAll(this.config.getNamespaces());
        this.mode = Mode.PREFIX;
        try {
            return this.Namespace();
        }
        catch (TokenMgrError error) {
            throw new ParseException("Unable to parse Prefix: (Message: " + error.getMessage() + ")");
        }
    }

    public Map<String, String> parsePrefixes() throws ParseException {
        this.namespaces.clear();
        this.namespaces.putAll(this.config.getNamespaces());
        this.mode = Mode.PREFIX;
        try {
            return this.Namespaces();
        }
        catch (TokenMgrError error) {
            throw new ParseException("Unable to parse Prefixes: (Message: " + error.getMessage() + ")");
        }
    }

    public NodeSelector<Node> parseSelector(Map<String, String> ctxNamespaces) throws ParseException {
        this.namespaces.clear();
        this.namespaces.putAll(this.config.getNamespaces());
        if (ctxNamespaces != null) {
            this.namespaces.putAll(ctxNamespaces);
        }
        this.mode = Mode.SELECTOR;
        try {
            return this.Selector();
        }
        catch (TokenMgrError error) {
            throw new ParseException("Unable to parse Selector: (Message: " + error.getMessage() + ")");
        }
    }

    public NodeTest<Node> parseTest(Map<String, String> ctxNamespaces) throws ParseException {
        this.namespaces.clear();
        this.namespaces.putAll(this.config.getNamespaces());
        if (ctxNamespaces != null) {
            this.namespaces.putAll(ctxNamespaces);
        }
        this.mode = Mode.TEST;
        try {
            return this.NodeTest();
        }
        catch (TokenMgrError error) {
            throw new ParseException("Unable to parse Test: (Message: " + error.getMessage() + ")");
        }
    }

    public <T> FieldMapping<T, Node> parseRule(Map<String, String> ctxNamespaces) throws ParseException {
        this.namespaces.clear();
        this.namespaces.putAll(this.config.getNamespaces());
        if (ctxNamespaces != null) {
            this.namespaces.putAll(ctxNamespaces);
        }
        this.mode = Mode.RULE;
        try {
            return this.Rule();
        }
        catch (TokenMgrError error) {
            throw new ParseException("Unable to parse Rule: (Message: " + error.getMessage() + ")");
        }
    }

    public Node resolveURI(URI uri) {
        return this.backend.createURI(uri.toString());
    }

    public Node resolveResource(String uri) throws ParseException {
        return this.backend.createURI(uri);
    }

    public Node resolveResource(String prefix, String local) throws ParseException {
        return this.resolveResource(this.resolveNamespace(prefix) + local);
    }

    public String resolveNamespace(String prefix) throws ParseException {
        String uri = this.namespaces.get(prefix);
        if (uri == null) {
            throw new ParseException("Namespace " + prefix + " not defined!");
        }
        return uri;
    }

    public SelectorFunction<Node> getFunction(String uri) throws ParseException {
        if (this.xsdNodeFunctionMap.get(uri) != null) {
            return this.xsdNodeFunctionMap.get(uri);
        }
        throw new ParseException("function with URI " + uri + " does not exist");
    }

    public TestFunction<Node> getTestFunction(String uri) throws ParseException {
        if (this.xsdNodeTestMap.get(uri) != null) {
            return this.xsdNodeTestMap.get(uri);
        }
        throw new ParseException("test function with URI " + uri + " does not exist");
    }

    public NodeTransformer<?, Node> getTransformer(URI type) throws ParseException {
        return this.getTransformer(type.toString());
    }

    public NodeTransformer<?, Node> getTransformer(Node node) throws ParseException {
        return this.getTransformer(this.backend.stringValue(node));
    }

    public NodeTransformer<?, Node> getTransformer(String uri) throws ParseException {
        if (this.xsdNodeTransformerMap.get(uri) != null) {
            return this.xsdNodeTransformerMap.get(uri);
        }
        throw new ParseException("transformer with URI " + uri + " does not exist");
    }

    private void initialise() {
        this.initTransformerMappings();
        this.initFunctionMappings();
    }

    public void registerFunction(SelectorFunction<Node> function) {
        this.registerFunction(this.xsdNodeFunctionMap, function);
    }

    public void registerFunction(TestFunction<Node> test) {
        this.registerTest(this.xsdNodeTestMap, test);
    }

    public void registerTransformer(String typeUri, NodeTransformer<?, Node> transformer) {
        this.xsdNodeTransformerMap.put(typeUri, transformer);
    }

    private void initTransformerMappings() {
        HashMap transformerMap = new HashMap();
        transformerMap.putAll(this.config.getTransformers());
        this.xsdNodeTransformerMap = transformerMap;
    }

    private void initFunctionMappings() {
        HashMap<String, SelectorFunction<Node>> functionMap = new HashMap<String, SelectorFunction<Node>>();
        functionMap.putAll(this.config.getFunctions());
        this.xsdNodeFunctionMap = functionMap;
        HashMap<String, TestFunction<Node>> testMap = new HashMap<String, TestFunction<Node>>();
        testMap.putAll(this.config.getTestFunctions());
        this.xsdNodeTestMap = testMap;
    }

    private void registerFunction(Map<String, SelectorFunction<Node>> register, SelectorFunction<Node> function) {
        register.put("http://www.newmedialab.at/lmf/functions/1.0/" + function.getPathExpression(this.backend), function);
    }

    private void registerTest(Map<String, TestFunction<Node>> register, TestFunction<Node> test) {
        register.put("http://www.newmedialab.at/lmf/functions/1.0/" + test.getLocalName(), test);
    }

    public final Map<String, String> Namespaces() throws ParseException {
        HashMap<String, String> ns = new HashMap<String, String>();
        Map.Entry<String, String> namespace = null;
        do {
            namespace = this.Namespace();
            ns.put(namespace.getKey(), namespace.getValue());
        } while (this.jj_2_1(Integer.MAX_VALUE));
        return ns;
    }

    public final Map.Entry<String, String> Namespace() throws ParseException {
        Token id = null;
        this.jj_consume_token(16);
        id = this.jj_consume_token(42);
        this.jj_consume_token(13);
        Token uri = this.jj_consume_token(41);
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(12);
        }
        return new Namespace(id.image, uri.image.substring(1, uri.image.length() - 1));
    }

    public final Program Program() throws ParseException {
        Program<Node> program = new Program<Node>();
        NodeTest filter = null;
        Map<String, String> nss = null;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            nss = this.Namespaces();
            this.namespaces.putAll(nss);
            for (String k : nss.keySet()) {
                program.addNamespace(k, nss.get(k));
            }
        }
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            this.jj_consume_token(19);
            LinkedList<URI> graphs = this.UriList();
            this.jj_consume_token(12);
            program.setGraphs(graphs);
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            this.jj_consume_token(17);
            filter = this.NodeTest();
            this.jj_consume_token(12);
            program.setFilter(filter);
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(18);
            NodeSelector boostSelector = this.Selector();
            this.jj_consume_token(12);
            NodeTransformer<?, Node> transformer = this.getTransformer("http://www.w3.org/2001/XMLSchema#float");
            FieldMapping booster = new FieldMapping("@boost", URI.create("http://www.w3.org/2001/XMLSchema#float"), boostSelector, transformer, null);
            program.setBooster(booster);
        }
        while (this.jj_2_7(Integer.MAX_VALUE)) {
            FieldMapping rule = this.Rule();
            program.addMapping(rule);
        }
        this.jj_consume_token(0);
        return program;
    }

    public final LinkedList<URI> UriList() throws ParseException {
        LinkedList<URI> rest = null;
        URI uri = this.Uri();
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(11);
            rest = this.UriList();
        }
        if (rest == null) {
            rest = new LinkedList<URI>();
        }
        rest.addFirst(uri);
        return rest;
    }

    public final FieldMapping Rule() throws ParseException {
        URI type = null;
        Map<String, String> conf = null;
        if (this.jj_2_16(Integer.MAX_VALUE)) {
            Token name = this.jj_consume_token(42);
            this.jj_consume_token(15);
            NodeSelector selector = this.Selector();
            if (this.jj_2_9(Integer.MAX_VALUE)) {
                this.jj_consume_token(14);
                type = this.Uri();
            }
            if (this.jj_2_10(Integer.MAX_VALUE)) {
                this.jj_consume_token(33);
                conf = this.FieldConfig();
                this.jj_consume_token(34);
            }
            this.jj_consume_token(12);
            NodeTransformer<Object, URI> transformer = type != null ? this.getTransformer((Node)type) : new IdentityTransformer<URI>();
            if (this.mode != Mode.PROGRAM) {
                throw new ParseException("cannot use field names when parsing single paths");
            }
            FieldMapping rule = new FieldMapping(name.image, type, selector, transformer, conf);
            return rule;
        }
        if (this.jj_2_17(Integer.MAX_VALUE)) {
            URI uri = this.Uri();
            this.jj_consume_token(15);
            NodeSelector selector = this.Selector();
            if (this.jj_2_11(Integer.MAX_VALUE)) {
                this.jj_consume_token(14);
                type = this.Uri();
            }
            if (this.jj_2_12(Integer.MAX_VALUE)) {
                this.jj_consume_token(33);
                conf = this.FieldConfig();
                this.jj_consume_token(34);
            }
            this.jj_consume_token(12);
            NodeTransformer<Object, URI> transformer = type != null ? this.getTransformer((Node)type) : new IdentityTransformer<URI>();
            if (this.mode != Mode.PROGRAM) {
                throw new ParseException("cannot use field names when parsing single paths");
            }
            FieldMapping rule = new FieldMapping(uri, type, selector, transformer, conf);
            return rule;
        }
        if (this.jj_2_18(Integer.MAX_VALUE)) {
            FieldMapping rule2;
            NodeSelector selector = this.Selector();
            if (this.jj_2_13(Integer.MAX_VALUE)) {
                this.jj_consume_token(14);
                type = this.Uri();
            }
            if (this.jj_2_14(Integer.MAX_VALUE)) {
                this.jj_consume_token(33);
                conf = this.FieldConfig();
                this.jj_consume_token(34);
            }
            if (this.jj_2_15(Integer.MAX_VALUE)) {
                this.jj_consume_token(12);
            }
            NodeTransformer<Object, URI> transformer = type != null ? this.getTransformer((Node)type) : new IdentityTransformer<URI>();
            if (this.mode != Mode.PROGRAM && conf != null) {
                throw new ParseException("cannot use configuration parameters when parsing single paths");
            }
            try {
                rule2 = new FieldMapping(selector.getName(this.backend), type, selector, transformer, conf);
            }
            catch (UnsupportedOperationException ex) {
                if (this.mode == Mode.PROGRAM) {
                    FieldMapping rule2 = new FieldMapping("unnamed", type, selector, transformer, conf);
                    log.error("error while parsing {}: {}", (Object)rule2.getPathExpression(this.backend), (Object)ex.getMessage());
                    throw new ParseException("error while parsing " + rule2.getPathExpression(this.backend) + ": " + ex.getMessage());
                }
                rule2 = new FieldMapping("unnamed", type, selector, transformer, conf);
            }
            return rule2;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Map<String, String> FieldConfig() throws ParseException {
        HashMap<String, String> conf = new HashMap<String, String>();
        Token key = null;
        String val = null;
        Map<String, String> more = null;
        if (this.jj_2_20(Integer.MAX_VALUE)) {
            key = this.jj_consume_token(42);
            this.jj_consume_token(15);
            val = this.ConfVal();
            if (this.jj_2_19(Integer.MAX_VALUE)) {
                this.jj_consume_token(11);
                more = this.FieldConfig();
            }
        }
        if (key == null || val == null) {
            return null;
        }
        conf.put(key.image, val);
        if (more != null) {
            conf.putAll(more);
        }
        return conf;
    }

    public final String ConfVal() throws ParseException {
        if (this.jj_2_21(Integer.MAX_VALUE)) {
            Token str = this.jj_consume_token(9);
            return str.image.substring(1, str.image.length() - 1);
        }
        if (this.jj_2_22(Integer.MAX_VALUE)) {
            Token id = this.jj_consume_token(42);
            return id.image;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final URI Uri() throws ParseException {
        if (this.jj_2_23(Integer.MAX_VALUE)) {
            Token uri = this.jj_consume_token(41);
            return URI.create(uri.image.substring(1, uri.image.length() - 1));
        }
        if (this.jj_2_24(Integer.MAX_VALUE)) {
            Token prefix = this.jj_consume_token(42);
            this.jj_consume_token(13);
            Token localName = this.jj_consume_token(42);
            return URI.create(this.resolveNamespace(prefix.image) + localName.image);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NodeSelector Selector() throws ParseException {
        NodeSelector result;
        if (this.jj_2_25(Integer.MAX_VALUE)) {
            result = this.CompoundSelector();
        } else if (this.jj_2_26(Integer.MAX_VALUE)) {
            result = this.TestingSelector();
        } else if (this.jj_2_27(Integer.MAX_VALUE)) {
            result = this.AtomicSelector();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final NodeSelector CompoundSelector() throws ParseException {
        NodeSelector result = null;
        if (this.jj_2_28(Integer.MAX_VALUE)) {
            result = this.UnionSelector();
        } else if (this.jj_2_29(Integer.MAX_VALUE)) {
            result = this.IntersectionSelector();
        } else if (this.jj_2_30(Integer.MAX_VALUE)) {
            result = this.PathSelector();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final NodeSelector AtomicOrTestingOrPathSelector() throws ParseException {
        NodeSelector result = null;
        if (this.jj_2_31(Integer.MAX_VALUE)) {
            result = this.PathSelector();
        } else if (this.jj_2_32(Integer.MAX_VALUE)) {
            result = this.AtomicOrTestingSelector();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final NodeSelector AtomicOrTestingSelector() throws ParseException {
        NodeSelector result = null;
        if (this.jj_2_33(Integer.MAX_VALUE)) {
            result = this.TestingSelector();
        } else if (this.jj_2_34(Integer.MAX_VALUE)) {
            result = this.AtomicSelector();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final NodeSelector AtomicSelector() throws ParseException {
        NodeSelector result = null;
        if (this.jj_2_35(Integer.MAX_VALUE)) {
            result = this.SelfSelector();
        } else if (this.jj_2_36(Integer.MAX_VALUE)) {
            result = this.PropertySelector();
        } else if (this.jj_2_37(Integer.MAX_VALUE)) {
            result = this.WildcardSelector();
        } else if (this.jj_2_38(Integer.MAX_VALUE)) {
            result = this.ReversePropertySelector();
        } else if (this.jj_2_39(Integer.MAX_VALUE)) {
            result = this.FunctionSelector();
        } else if (this.jj_2_40(Integer.MAX_VALUE)) {
            result = this.StringConstantSelector();
        } else if (this.jj_2_41(Integer.MAX_VALUE)) {
            result = this.RecursivePathSelector();
        } else if (this.jj_2_42(Integer.MAX_VALUE)) {
            result = this.GroupedSelector();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final NodeSelector SelfSelector() throws ParseException {
        this.jj_consume_token(20);
        return new SelfSelector();
    }

    public final NodeSelector GroupedSelector() throws ParseException {
        NodeSelector result = null;
        this.jj_consume_token(33);
        result = this.Selector();
        this.jj_consume_token(34);
        return new GroupedSelector(result);
    }

    public final RecursivePathSelector RecursivePathSelector() throws ParseException {
        RecursivePathSelector result = null;
        NodeSelector delegate = null;
        if (this.jj_2_43(Integer.MAX_VALUE)) {
            this.jj_consume_token(33);
            delegate = this.Selector();
            this.jj_consume_token(34);
            this.jj_consume_token(24);
            result = RecursivePathSelector.getPathSelectorPlused(delegate);
            return result;
        }
        if (this.jj_2_44(Integer.MAX_VALUE)) {
            this.jj_consume_token(33);
            delegate = this.Selector();
            this.jj_consume_token(34);
            this.jj_consume_token(25);
            result = RecursivePathSelector.getPathSelectorStared(delegate);
            return result;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PathSelector PathSelector() throws ParseException {
        PathSelector result = null;
        NodeSelector left = null;
        NodeSelector right = null;
        left = this.AtomicOrTestingSelector();
        this.jj_consume_token(23);
        right = this.AtomicOrTestingOrPathSelector();
        result = new PathSelector(left, right);
        return result;
    }

    public final IntersectionSelector IntersectionSelector() throws ParseException {
        IntersectionSelector result = null;
        NodeSelector left = null;
        NodeSelector right = null;
        left = this.AtomicOrTestingOrPathSelector();
        this.jj_consume_token(21);
        right = this.Selector();
        result = new IntersectionSelector(left, right);
        return result;
    }

    public final UnionSelector UnionSelector() throws ParseException {
        UnionSelector result = null;
        NodeSelector left = null;
        NodeSelector right = null;
        left = this.AtomicOrTestingOrPathSelector();
        this.jj_consume_token(22);
        right = this.Selector();
        result = new UnionSelector(left, right);
        return result;
    }

    public final TestingSelector TestingSelector() throws ParseException {
        TestingSelector result = null;
        NodeSelector delegate = null;
        NodeTest test = null;
        delegate = this.AtomicSelector();
        this.jj_consume_token(35);
        test = this.NodeTest();
        this.jj_consume_token(36);
        result = new TestingSelector(delegate, test);
        return result;
    }

    public final ReversePropertySelector ReversePropertySelector() throws ParseException {
        ReversePropertySelector<Node> result = null;
        this.jj_consume_token(27);
        URI uri = this.Uri();
        result = new ReversePropertySelector<Node>(this.resolveURI(uri));
        return result;
    }

    public final PropertySelector PropertySelector() throws ParseException {
        PropertySelector<Node> result = null;
        URI uri = this.Uri();
        result = new PropertySelector<Node>(this.resolveURI(uri));
        return result;
    }

    public final WildcardSelector WildcardSelector() throws ParseException {
        WildcardSelector result = null;
        this.jj_consume_token(25);
        result = new WildcardSelector();
        return result;
    }

    public final FunctionSelector FunctionSelector() throws ParseException {
        FunctionSelector result = null;
        ArrayList arguments = new ArrayList();
        if (this.jj_2_46(Integer.MAX_VALUE)) {
            this.jj_consume_token(30);
            Token fName = this.jj_consume_token(42);
            this.jj_consume_token(33);
            this.jj_consume_token(34);
            String uri = this.namespaces.get("fn") + fName.image;
            result = new FunctionSelector(this.getFunction(uri), Collections.emptyList());
            return result;
        }
        if (this.jj_2_47(Integer.MAX_VALUE)) {
            this.jj_consume_token(30);
            Token fName = this.jj_consume_token(42);
            this.jj_consume_token(33);
            NodeSelector argument = this.Selector();
            arguments.add(argument);
            while (this.jj_2_45(Integer.MAX_VALUE)) {
                this.jj_consume_token(11);
                argument = this.Selector();
                arguments.add(argument);
            }
            this.jj_consume_token(34);
            String uri = this.namespaces.get("fn") + fName.image;
            result = new FunctionSelector(this.getFunction(uri), arguments);
            return result;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StringConstantSelector StringConstantSelector() throws ParseException {
        StringConstantSelector result = null;
        Token literal = this.jj_consume_token(9);
        result = new StringConstantSelector(literal.image.substring(1, literal.image.length() - 1));
        return result;
    }

    public final NodeTest NodeTest() throws ParseException {
        NodeTest result;
        if (this.jj_2_48(Integer.MAX_VALUE)) {
            result = this.GroupedTest();
        } else if (this.jj_2_49(Integer.MAX_VALUE)) {
            result = this.NotTest();
        } else if (this.jj_2_50(Integer.MAX_VALUE)) {
            result = this.AndTest();
        } else if (this.jj_2_51(Integer.MAX_VALUE)) {
            result = this.OrTest();
        } else if (this.jj_2_52(Integer.MAX_VALUE)) {
            result = this.AtomicNodeTest();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final NodeTest GroupedTest() throws ParseException {
        this.jj_consume_token(33);
        NodeTest delegate = this.NodeTest();
        this.jj_consume_token(34);
        return delegate;
    }

    public final NodeTest AtomicNodeTest() throws ParseException {
        NodeTest result;
        if (this.jj_2_53(Integer.MAX_VALUE)) {
            result = this.LiteralLanguageTest();
        } else if (this.jj_2_54(Integer.MAX_VALUE)) {
            result = this.LiteralTypeTest();
        } else if (this.jj_2_55(Integer.MAX_VALUE)) {
            result = this.IsATest();
        } else if (this.jj_2_56(Integer.MAX_VALUE)) {
            result = this.PathEqualityTest();
        } else if (this.jj_2_57(Integer.MAX_VALUE)) {
            result = this.FunctionTest();
        } else if (this.jj_2_58(Integer.MAX_VALUE)) {
            result = this.PathTest();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final FunctionTest FunctionTest() throws ParseException {
        FunctionTest<Node> result;
        ArrayList arguments = new ArrayList();
        if (this.jj_2_60(Integer.MAX_VALUE)) {
            this.jj_consume_token(30);
            Token fName = this.jj_consume_token(42);
            this.jj_consume_token(33);
            this.jj_consume_token(34);
            String uri = this.namespaces.get("fn") + fName.image;
            result = new FunctionTest<Node>(this.getTestFunction(uri), Collections.emptyList());
        } else if (this.jj_2_61(Integer.MAX_VALUE)) {
            this.jj_consume_token(30);
            Token fName = this.jj_consume_token(42);
            this.jj_consume_token(33);
            NodeSelector argument = this.Selector();
            arguments.add(argument);
            while (this.jj_2_59(Integer.MAX_VALUE)) {
                this.jj_consume_token(11);
                argument = this.Selector();
                arguments.add(argument);
            }
            this.jj_consume_token(34);
            String uri = this.namespaces.get("fn") + fName.image;
            result = new FunctionTest<Node>(this.getTestFunction(uri), arguments);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return result;
    }

    public final LiteralLanguageTest LiteralLanguageTest() throws ParseException {
        this.jj_consume_token(32);
        Token lang = this.jj_consume_token(42);
        return new LiteralLanguageTest(lang.image);
    }

    public final LiteralTypeTest LiteralTypeTest() throws ParseException {
        this.jj_consume_token(31);
        URI type = this.Uri();
        return new LiteralTypeTest(type);
    }

    public final NotTest NotTest() throws ParseException {
        this.jj_consume_token(26);
        NodeTest delegate = this.NodeTest();
        return new NotTest(delegate);
    }

    public final IsATest IsATest() throws ParseException {
        this.jj_consume_token(29);
        Node node = this.Node();
        return new IsATest<Node>(this.resolveResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), node);
    }

    public final AndTest AndTest() throws ParseException {
        NodeTest left = this.AtomicNodeTest();
        this.jj_consume_token(21);
        NodeTest right = this.NodeTest();
        return new AndTest(left, right);
    }

    public final OrTest OrTest() throws ParseException {
        NodeTest left = this.AtomicNodeTest();
        this.jj_consume_token(22);
        NodeTest right = this.NodeTest();
        return new OrTest(left, right);
    }

    public final PathEqualityTest PathEqualityTest() throws ParseException {
        NodeSelector path = this.Selector();
        this.jj_consume_token(28);
        Node node = this.Node();
        return new PathEqualityTest<Node>(path, node);
    }

    public final Node Node() throws ParseException {
        URI type = null;
        if (this.jj_2_63(Integer.MAX_VALUE)) {
            URI uri = this.Uri();
            return this.resolveURI(uri);
        }
        if (this.jj_2_64(Integer.MAX_VALUE)) {
            Token literal = this.jj_consume_token(9);
            if (this.jj_2_62(Integer.MAX_VALUE)) {
                this.jj_consume_token(31);
                type = this.Uri();
            }
            return this.backend.createLiteral(literal.image.substring(1, literal.image.length() - 1), null, type);
        }
        if (this.jj_2_65(Integer.MAX_VALUE)) {
            Token literal = this.jj_consume_token(9);
            this.jj_consume_token(32);
            Token language = this.jj_consume_token(42);
            return this.backend.createLiteral(literal.image.substring(1, literal.image.length() - 1), new Locale(language.image), null);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PathTest PathTest() throws ParseException {
        NodeSelector path;
        if (this.jj_2_66(Integer.MAX_VALUE)) {
            path = this.PathSelector();
        } else if (this.jj_2_67(Integer.MAX_VALUE)) {
            path = this.TestingSelector();
        } else if (this.jj_2_68(Integer.MAX_VALUE)) {
            path = this.AtomicSelector();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return new PathTest(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_17() {
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3_52() {
        return this.jj_3R_33();
    }

    private boolean jj_3_51() {
        return this.jj_3R_32();
    }

    private boolean jj_3_50() {
        return this.jj_3R_31();
    }

    private boolean jj_3_42() {
        return this.jj_3R_28();
    }

    private boolean jj_3_49() {
        return this.jj_3R_30();
    }

    private boolean jj_3_48() {
        return this.jj_3R_29();
    }

    private boolean jj_3_41() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_18()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_49()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_50()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_51()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_52()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_40() {
        return this.jj_3R_26();
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_39() {
        return this.jj_3R_25();
    }

    private boolean jj_3_38() {
        return this.jj_3R_24();
    }

    private boolean jj_3_37() {
        return this.jj_3R_23();
    }

    private boolean jj_3_36() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_26() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_62() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_68() {
        return this.jj_3R_16();
    }

    private boolean jj_3_67() {
        return this.jj_3R_15();
    }

    private boolean jj_3_35() {
        return this.jj_3R_21();
    }

    private boolean jj_3_66() {
        return this.jj_3R_19();
    }

    private boolean jj_3R_7() {
        if (this.jj_3R_11()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_45() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_66()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_67()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_68()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_36()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_37()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_38()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_39()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_40()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_41()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_42()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3_34() {
        return this.jj_3R_16();
    }

    private boolean jj_3_47() {
        Token xsp;
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_45());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(34);
    }

    private boolean jj_3_65() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3_33() {
        return this.jj_3R_15();
    }

    private boolean jj_3_7() {
        return this.jj_3R_10();
    }

    private boolean jj_3_64() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_62()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_47()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_46() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_64()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_65()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_63() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_34()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3_32() {
        return this.jj_3R_20();
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_37() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_41();
    }

    private boolean jj_3_31() {
        return this.jj_3R_19();
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_32() {
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private boolean jj_3_3() {
        return this.jj_3R_6();
    }

    private boolean jj_3_30() {
        return this.jj_3R_19();
    }

    private boolean jj_3R_31() {
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private boolean jj_3R_22() {
        return this.jj_3R_11();
    }

    private boolean jj_3_29() {
        return this.jj_3R_18();
    }

    private boolean jj_3_28() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_24() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_15() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_29()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_30()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_36() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_41();
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private boolean jj_3R_5() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_27() {
        return this.jj_3R_16();
    }

    private boolean jj_3_26() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private boolean jj_3_25() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_15() {
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3_1() {
        return this.jj_3R_5();
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_26()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_27()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_6() {
        Token xsp;
        if (this.jj_3_1()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_1());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_35() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_24() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_17() {
        if (this.jj_3R_40()) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_24()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_23() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_34() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_22() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_21() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_14() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_59() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_18() {
        if (this.jj_3R_40()) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_61() {
        Token xsp;
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_59());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(34);
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_60() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_19() {
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_40();
    }

    private boolean jj_3_9() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_13() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_61()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_44() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_44()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_43() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_58() {
        return this.jj_3R_39();
    }

    private boolean jj_3_57() {
        return this.jj_3R_38();
    }

    private boolean jj_3_56() {
        return this.jj_3R_37();
    }

    private boolean jj_3_55() {
        return this.jj_3R_36();
    }

    private boolean jj_3_54() {
        return this.jj_3R_35();
    }

    private boolean jj_3_53() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_54()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_55()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_56()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_57()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_58()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_18() {
        if (this.jj_3R_9()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    public LdPathParser(InputStream stream) {
        this(stream, null);
    }

    public LdPathParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new LdPathParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public LdPathParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new LdPathParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public LdPathParser(LdPathParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(LdPathParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[44];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 44; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 68; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                            break;
                        }
                        case 57: {
                            this.jj_3_58();
                            break;
                        }
                        case 58: {
                            this.jj_3_59();
                            break;
                        }
                        case 59: {
                            this.jj_3_60();
                            break;
                        }
                        case 60: {
                            this.jj_3_61();
                            break;
                        }
                        case 61: {
                            this.jj_3_62();
                            break;
                        }
                        case 62: {
                            this.jj_3_63();
                            break;
                        }
                        case 63: {
                            this.jj_3_64();
                            break;
                        }
                        case 64: {
                            this.jj_3_65();
                            break;
                        }
                        case 65: {
                            this.jj_3_66();
                            break;
                        }
                        case 66: {
                            this.jj_3_67();
                            break;
                        }
                        case 67: {
                            this.jj_3_68();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        LdPathParser.jj_la1_init_0();
        LdPathParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private class Namespace
    implements Map.Entry<String, String> {
        private String key;
        private String val;

        public Namespace(String key, String val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.val;
        }

        @Override
        public String setValue(String value) {
            String oV = this.val;
            this.val = value;
            return oV;
        }
    }

    private static enum Mode {
        RULE,
        SELECTOR,
        TEST,
        PROGRAM,
        PREFIX;

    }
}

