/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.ldpath;

import java.util.Collections;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.endpoint.rdf.LinkedDataEndpoint;
import org.apache.marmotta.ldclient.model.ClientConfiguration;
import org.apache.marmotta.ldclient.provider.rdf.CacheProvider;
import org.apache.marmotta.ldclient.provider.rdf.LinkedDataProvider;
import org.apache.marmotta.ldclient.provider.rdf.RegexUriProvider;
import org.apache.marmotta.ldclient.provider.rdf.SPARQLProvider;

public class ClientFactory {
    public static ClientConfiguration createClient(Endpoint fedoraEndpoint) {
        return ClientFactory.createClient(null, null, fedoraEndpoint, Collections.emptyList(), Collections.emptyList());
    }

    public static ClientConfiguration createClient(Endpoint fedoraEndpoint, List<Endpoint> endpoints, List<DataProvider> providers) {
        return ClientFactory.createClient(null, null, fedoraEndpoint, endpoints, providers);
    }

    public static ClientConfiguration createClient(AuthScope authScope, Credentials credentials, Endpoint fedoraEndpoint) {
        return ClientFactory.createClient(authScope, credentials, fedoraEndpoint, Collections.emptyList(), Collections.emptyList());
    }

    public static ClientConfiguration createClient(AuthScope authScope, Credentials credentials, Endpoint fedoraEndpoint, List<Endpoint> endpoints, List<DataProvider> providers) {
        ClientConfiguration client = new ClientConfiguration();
        if (credentials != null && authScope != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(authScope, credentials);
            client.setHttpClient((HttpClient)HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).useSystemProperties().build());
        }
        client.addEndpoint(fedoraEndpoint);
        client.addProvider((DataProvider)((Object)new LinkedDataProvider()));
        client.addProvider((DataProvider)((Object)new CacheProvider()));
        client.addProvider((DataProvider)((Object)new RegexUriProvider()));
        client.addProvider((DataProvider)((Object)new SPARQLProvider()));
        client.addEndpoint(new LinkedDataEndpoint());
        endpoints.forEach(client::addEndpoint);
        providers.forEach(client::addProvider);
        return client;
    }

    private ClientFactory() {
    }
}

