/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import javolution.lang.Realtime;
import javolution.util.FastCollection;
import javolution.util.FastTable;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.internal.table.sorted.AtomicSortedTableImpl;
import javolution.util.internal.table.sorted.FastSortedTableImpl;
import javolution.util.internal.table.sorted.SharedSortedTableImpl;
import javolution.util.internal.table.sorted.UnmodifiableSortedTableImpl;
import javolution.util.service.SortedTableService;

public class FastSortedTable<E>
extends FastTable<E> {
    private static final long serialVersionUID = 1536L;

    public FastSortedTable() {
        this(Equalities.STANDARD);
    }

    public FastSortedTable(Equality<? super E> comparator) {
        super(new FastSortedTableImpl<E>(comparator));
    }

    protected FastSortedTable(SortedTableService<E> service) {
        super(service);
    }

    @Override
    public FastSortedTable<E> atomic() {
        return new FastSortedTable(new AtomicSortedTableImpl(this.service()));
    }

    @Override
    public FastSortedTable<E> shared() {
        return new FastSortedTable(new SharedSortedTableImpl(this.service()));
    }

    @Override
    public FastSortedTable<E> unmodifiable() {
        return new FastSortedTable(new UnmodifiableSortedTableImpl(this.service()));
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean contains(Object obj) {
        return this.service().contains(obj);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean remove(Object obj) {
        return this.service().remove(obj);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public int indexOf(Object obj) {
        return this.service().indexOf(obj);
    }

    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean addIfAbsent(E element) {
        return this.service().addIfAbsent(element);
    }

    @Realtime(limit=Realtime.Limit.LOG_N)
    public int positionOf(E element) {
        return this.service().positionOf(element);
    }

    @Override
    public FastSortedTable<E> addAll(E ... elements) {
        return (FastSortedTable)super.addAll((Object[])elements);
    }

    @Override
    public FastSortedTable<E> addAll(FastCollection<? extends E> that) {
        return (FastSortedTable)super.addAll((FastCollection)that);
    }

    @Override
    protected SortedTableService<E> service() {
        return (SortedTableService)super.service();
    }
}

