/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javolution.util.function.Equality;
import javolution.util.internal.table.FractalTableImpl;
import javolution.util.internal.table.TableView;

public class FastTableImpl<E>
extends TableView<E> {
    private static final long serialVersionUID = 1536L;
    private transient int capacity;
    private final Equality<? super E> comparator;
    private transient FractalTableImpl fractal;
    private transient int size;

    public FastTableImpl(Equality<? super E> comparator) {
        super(null);
        this.comparator = comparator;
    }

    @Override
    public boolean add(E element) {
        this.addLast(element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.size) {
            this.indexError(index);
        }
        this.checkUpsize();
        if (index >= this.size >> 1) {
            this.fractal.shiftRight(element, index, this.size - index);
        } else {
            this.fractal.shiftLeft(element, index - 1, index);
            --this.fractal.offset;
        }
        ++this.size;
    }

    @Override
    public void addFirst(E element) {
        this.checkUpsize();
        --this.fractal.offset;
        this.fractal.set(0, element);
        ++this.size;
    }

    @Override
    public void addLast(E element) {
        this.checkUpsize();
        this.fractal.set(this.size++, element);
    }

    @Override
    public void clear() {
        this.fractal = null;
        this.capacity = 0;
        this.size = 0;
    }

    @Override
    public FastTableImpl<E> clone() {
        FastTableImpl<E> copy = new FastTableImpl<E>(this.comparator());
        copy.addAll(this);
        return copy;
    }

    @Override
    public Equality<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public E get(int index) {
        if (index < 0 && index >= this.size) {
            this.indexError(index);
        }
        return (E)this.fractal.get(index);
    }

    @Override
    public E getFirst() {
        if (this.size == 0) {
            this.emptyError();
        }
        return this.get(0);
    }

    @Override
    public E getLast() {
        if (this.size == 0) {
            this.emptyError();
        }
        return this.get(this.size - 1);
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.size) {
            this.indexError(index);
        }
        Object removed = this.fractal.get(index);
        if (index >= this.size >> 1) {
            this.fractal.shiftLeft(null, this.size - 1, this.size - index - 1);
        } else {
            this.fractal.shiftRight(null, 0, index);
            ++this.fractal.offset;
        }
        --this.size;
        return (E)removed;
    }

    @Override
    public E removeFirst() {
        if (this.size == 0) {
            this.emptyError();
        }
        Object first = this.fractal.set(0, null);
        ++this.fractal.offset;
        --this.size;
        return (E)first;
    }

    @Override
    public E removeLast() {
        if (this.size == 0) {
            this.emptyError();
        }
        Object last = this.fractal.set(--this.size, null);
        return (E)last;
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 && index >= this.size) {
            this.indexError(index);
        }
        return (E)this.fractal.set(index, element);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void checkUpsize() {
        if (this.size >= this.capacity) {
            this.upsize();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int n = s.readInt();
        for (int i = 0; i < n; ++i) {
            this.addLast(s.readObject());
        }
    }

    private void upsize() {
        this.fractal = this.fractal == null ? new FractalTableImpl() : this.fractal.upsize();
        this.capacity = this.fractal.capacity();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.fractal.get(i));
        }
    }

    private class IteratorImpl
    implements Iterator<E> {
        private int currentIndex = -1;
        private int nextIndex;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < FastTableImpl.this.size;
        }

        @Override
        public E next() {
            if (this.nextIndex >= FastTableImpl.this.size) {
                throw new NoSuchElementException();
            }
            this.currentIndex = this.nextIndex++;
            return FastTableImpl.this.fractal.get(this.currentIndex);
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException();
            }
            FastTableImpl.this.remove(this.currentIndex);
            --this.nextIndex;
            this.currentIndex = -1;
        }
    }
}

