/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table.sorted;

import javolution.util.function.Equality;
import javolution.util.internal.table.FastTableImpl;
import javolution.util.internal.table.sorted.SubSortedTableImpl;
import javolution.util.service.SortedTableService;

public class FastSortedTableImpl<E>
extends FastTableImpl<E>
implements SortedTableService<E> {
    private static final long serialVersionUID = 1536L;

    public FastSortedTableImpl(Equality<? super E> comparator) {
        super(comparator);
    }

    @Override
    public boolean add(E element) {
        this.add(this.positionOf(element), element);
        return true;
    }

    @Override
    public boolean addIfAbsent(E element) {
        int i = this.positionOf(element);
        if (i < this.size() && this.comparator().areEqual(element, this.get(i))) {
            return false;
        }
        this.add(i, element);
        return true;
    }

    @Override
    public int indexOf(Object element) {
        int i = this.positionOf(element);
        if (i >= this.size() || !this.comparator().areEqual(this.get(i), element)) {
            return -1;
        }
        return i;
    }

    @Override
    public int positionOf(E element) {
        return this.positionOf(element, 0, this.size());
    }

    @Override
    public SortedTableService<E>[] split(int n, boolean updateable) {
        return SubSortedTableImpl.splitOf(this, n, updateable);
    }

    private int positionOf(E element, int start, int length) {
        if (length == 0) {
            return start;
        }
        int half = length >> 1;
        return this.comparator().compare(element, this.get(start + half)) <= 0 ? this.positionOf(element, start, half) : this.positionOf(element, start + half + 1, length - half - 1);
    }
}

