/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.rdf;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.exception.DataRetrievalException;
import org.apache.marmotta.ldclient.provider.rdf.AbstractRDFProvider;

public class RegexUriProvider
extends AbstractRDFProvider {
    public String getName() {
        return "RegexUri";
    }

    protected List<String> buildRequestUrl(String resourceUri, Endpoint endpoint) throws DataRetrievalException {
        Preconditions.checkNotNull((Object)resourceUri);
        Preconditions.checkNotNull((Object)endpoint);
        Pattern p = (Pattern)Preconditions.checkNotNull((Object)endpoint.getUriPatternCompiled());
        Matcher matcher = p.matcher(resourceUri);
        return Collections.singletonList(matcher.replaceAll(endpoint.getEndpointUrl()));
    }
}

