/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.backend;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.util.FormatUtils;

public abstract class AbstractBackend<Node>
implements NodeBackend<Node> {
    private SimpleDateFormat dateFormat = (SimpleDateFormat)FormatUtils.ISO8601FORMAT_DATE.clone();
    private SimpleDateFormat timeFormat = (SimpleDateFormat)FormatUtils.ISO8601FORMAT_TIME.clone();

    @Override
    public Double doubleValue(Node node) {
        return new Double(AbstractBackend.trimPlusSign(this.stringValue(node)));
    }

    @Override
    public Float floatValue(Node node) {
        return new Float(AbstractBackend.trimPlusSign(this.stringValue(node)));
    }

    @Override
    public Long longValue(Node node) {
        return this.decimalValue(node).longValueExact();
    }

    @Override
    public Integer intValue(Node node) {
        return this.decimalValue(node).intValueExact();
    }

    @Override
    public BigDecimal decimalValue(Node node) {
        return new BigDecimal(AbstractBackend.trimPlusSign(this.stringValue(node)));
    }

    @Override
    public BigInteger integerValue(Node node) {
        return this.decimalValue(node).toBigIntegerExact();
    }

    @Override
    public Boolean booleanValue(Node node) {
        String lexicalForm = this.stringValue(node);
        if (lexicalForm.length() == 1) {
            return lexicalForm.charAt(0) == '1';
        }
        return Boolean.parseBoolean(lexicalForm);
    }

    @Override
    public Date dateValue(Node node) {
        String lexicalForm = this.stringValue(node);
        try {
            return this.parseDate(lexicalForm);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("could not parse ISO8601 date from '" + lexicalForm + "'!", e);
        }
    }

    @Override
    public Date timeValue(Node node) {
        String lexicalForm = this.stringValue(node);
        try {
            return this.parseTime(lexicalForm);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("could not parse ISO8601 time from '" + lexicalForm + "'!", e);
        }
    }

    @Override
    public Date dateTimeValue(Node node) {
        String lexicalForm = this.stringValue(node);
        Date date = FormatUtils.parseDate(lexicalForm);
        if (date == null) {
            throw new IllegalArgumentException("could not parse xsd:dateTime from '" + lexicalForm + "'!");
        }
        return date;
    }

    @Override
    public abstract String stringValue(Node var1);

    private static String trimPlusSign(String s) {
        return s.length() > 0 && s.charAt(0) == '+' ? s.substring(1) : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseDate(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return this.dateFormat.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseTime(String timeString) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.timeFormat;
        synchronized (simpleDateFormat) {
            return this.timeFormat.parse(timeString);
        }
    }
}

