/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.selectors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;

public class IntersectionSelector<Node>
implements NodeSelector<Node> {
    private NodeSelector<Node> left;
    private NodeSelector<Node> right;

    public IntersectionSelector(NodeSelector<Node> left, NodeSelector<Node> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Collection<Node> select(RDFBackend<Node> nodeRDFBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        return Sets.intersection((Set)ImmutableSet.copyOf(this.left.select(nodeRDFBackend, context, path, resultPaths)), (Set)ImmutableSet.copyOf(this.right.select(nodeRDFBackend, context, path, resultPaths)));
    }

    @Override
    public String getPathExpression(NodeBackend<Node> backend) {
        return String.format("%s & %s", this.left.getPathExpression(backend), this.right.getPathExpression(backend));
    }

    @Override
    public String getName(NodeBackend<Node> nodeRDFBackend) {
        throw new UnsupportedOperationException("cannot use intersections in unnamed field definitions because the name is ambiguous");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntersectionSelector that = (IntersectionSelector)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }
}

