/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.tests;

import java.net.URI;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.tests.NodeTest;

public class LiteralTypeTest<Node>
extends NodeTest<Node> {
    private URI typeUri;

    public LiteralTypeTest(String typeUri) {
        this.typeUri = URI.create(typeUri);
    }

    public LiteralTypeTest(URI uri) {
        this.typeUri = uri;
    }

    @Override
    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node node) throws IllegalArgumentException {
        if (rdfBackend.isLiteral(node)) {
            if (this.typeUri != null) {
                return this.typeUri.equals(rdfBackend.getLiteralType(node));
            }
            return null == rdfBackend.getLiteralType(node);
        }
        return false;
    }

    @Override
    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        return String.format("^^<%s>", this.typeUri);
    }

    @Override
    public String getSignature() {
        return "nodes [^^typeUri] :: (NodeList, URI) -> Boolean";
    }

    @Override
    public String getDescription() {
        return "Tests the types of the nodes passed as argument";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralTypeTest that = (LiteralTypeTest)o;
        return !(this.typeUri != null ? !this.typeUri.equals(that.typeUri) : that.typeUri != null);
    }

    public int hashCode() {
        return this.typeUri != null ? this.typeUri.hashCode() : 0;
    }
}

