/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.tests;

import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.tests.NodeTest;
import org.apache.marmotta.ldpath.model.tests.ComplexTest;

public class NotTest<Node>
extends NodeTest<Node> {
    private final NodeTest<Node> delegate;

    public NotTest(NodeTest<Node> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean accept(RDFBackend<Node> backend, Node context, Node args) throws IllegalArgumentException {
        return !this.delegate.accept(backend, context, args);
    }

    @Override
    public String getPathExpression(NodeBackend<Node> backend) {
        if (this.delegate instanceof ComplexTest) {
            return String.format("!(%s)", this.delegate.getPathExpression(backend));
        }
        return String.format("!%s", this.delegate.getPathExpression(backend));
    }

    @Override
    public String getSignature() {
        return "!test :: Boolean -> Boolean";
    }

    @Override
    public String getDescription() {
        return "Negates the test given as argument";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotTest notTest = (NotTest)o;
        return !(this.delegate != null ? !this.delegate.equals(notTest.delegate) : notTest.delegate != null);
    }

    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : 0;
    }
}

