/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.marmotta.commons.sesame.repository.ExceptionUtils;
import org.apache.marmotta.commons.sesame.repository.ResourceUtils;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class ResultUtils {
    public static <T> Iterator<T> unwrap(final RepositoryResult<T> result) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (result.isClosed()) {
                    return false;
                }
                try {
                    return result.hasNext();
                }
                catch (RepositoryException e) {
                    ExceptionUtils.handleRepositoryException(e, ResourceUtils.class);
                    return false;
                }
            }

            @Override
            public T next() {
                try {
                    Object next = result.next();
                    if (!result.hasNext()) {
                        result.close();
                    }
                    return next;
                }
                catch (RepositoryException e) {
                    ExceptionUtils.handleRepositoryException(e, ResourceUtils.class);
                    return null;
                }
            }

            @Override
            public void remove() {
                try {
                    result.remove();
                }
                catch (RepositoryException e) {
                    ExceptionUtils.handleRepositoryException(e, ResourceUtils.class);
                }
            }

            protected void finalize() throws Throwable {
                if (!result.isClosed()) {
                    result.close();
                }
                super.finalize();
            }
        };
    }

    public static <T> Iterable<T> iterable(final RepositoryResult<T> result) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return ResultUtils.unwrap(result);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> List<E> asList(RepositoryResult<E> result) throws RepositoryException {
        ArrayList<Object> collection = new ArrayList<Object>();
        try {
            while (result.hasNext()) {
                collection.add(result.next());
            }
            ArrayList<Object> arrayList = collection;
            return arrayList;
        }
        finally {
            result.close();
        }
    }
}

