/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.tests;

import java.util.Locale;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.tests.NodeTest;

public class LiteralLanguageTest<Node>
extends NodeTest<Node> {
    private String lang;

    public LiteralLanguageTest(String lang) {
        this.lang = lang;
    }

    @Override
    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node node) throws IllegalArgumentException {
        if (rdfBackend.isLiteral(node)) {
            if (this.lang != null && !this.lang.toLowerCase().equals("none")) {
                return new Locale(this.lang).equals(rdfBackend.getLiteralLanguage(node));
            }
            return rdfBackend.getLiteralLanguage(node) == null;
        }
        return false;
    }

    @Override
    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        return "@" + this.lang;
    }

    @Override
    public String getSignature() {
        return "nodes [@lang] :: (NodeList, Language) -> Boolean";
    }

    @Override
    public String getDescription() {
        return "Tests the language of the literal nodes passed as argument";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralLanguageTest that = (LiteralLanguageTest)o;
        return !(this.lang != null ? !this.lang.equals(that.lang) : that.lang != null);
    }

    public int hashCode() {
        return this.lang != null ? this.lang.hashCode() : 0;
    }
}

