/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.ldpath;

import com.github.jsonldjava.sesame.SesameJSONLDParserFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.ldpath.LDPath;
import org.apache.marmotta.ldpath.backend.linkeddata.LDCacheBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.sparqlxml.SPARQLBooleanXMLParserFactory;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.n3.N3ParserFactory;
import org.openrdf.rio.ntriples.NTriplesParserFactory;
import org.openrdf.rio.rdfjson.RDFJSONParserFactory;
import org.openrdf.rio.rdfxml.RDFXMLParserFactory;
import org.openrdf.rio.trig.TriGParserFactory;
import org.openrdf.rio.turtle.TurtleParserFactory;
import org.semarglproject.sesame.rdf.rdfa.SesameRDFaParserFactory;

public class LDPathWrapper {
    private final LDPath<Value> ldpath;

    public LDPathWrapper(LDCacheBackend backend) {
        RDFParserRegistry.getInstance().add((Object)new RDFXMLParserFactory());
        RDFParserRegistry.getInstance().add((Object)new NTriplesParserFactory());
        RDFParserRegistry.getInstance().add((Object)new TurtleParserFactory());
        RDFParserRegistry.getInstance().add((Object)new N3ParserFactory());
        RDFParserRegistry.getInstance().add((Object)new SesameJSONLDParserFactory());
        RDFParserRegistry.getInstance().add((Object)new RDFJSONParserFactory());
        RDFParserRegistry.getInstance().add((Object)new SesameRDFaParserFactory());
        RDFParserRegistry.getInstance().add((Object)new TriGParserFactory());
        BooleanQueryResultParserRegistry.getInstance().add((Object)new SPARQLBooleanXMLParserFactory());
        TupleQueryResultParserRegistry.getInstance().add((Object)new SPARQLResultsXMLParserFactory());
        this.ldpath = new LDPath<Value>(backend);
    }

    public List<Map<String, Collection<?>>> programQuery(String uri, InputStream program) throws LDPathParseException {
        return Collections.singletonList(this.ldpath.programQuery((Value)new URIImpl(uri), new InputStreamReader(program)));
    }
}

