/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map;

import javolution.util.function.Equality;
import javolution.util.internal.map.MapEntryImpl;

final class FractalMapImpl {
    static final int EMPTINESS_LEVEL = 2;
    static final int INITIAL_BLOCK_CAPACITY = 8;
    static final int SHIFT = 10;
    private int count;
    private MapEntryImpl[] entries = new MapEntryImpl[8];
    private final int shift;

    public FractalMapImpl() {
        this.shift = 0;
    }

    public FractalMapImpl(int shift) {
        this.shift = shift;
    }

    public MapEntryImpl addEntry(MapEntryImpl newEntry, Object key, int hash, Equality comparator) {
        int i = this.indexOfKey(key, hash, comparator);
        MapEntryImpl entry = this.entries[i];
        if (entry != null) {
            return entry;
        }
        this.entries[i] = newEntry;
        newEntry.key = key;
        newEntry.hash = hash;
        if (++this.count << 2 > this.entries.length) {
            this.resize(this.entries.length << 1);
        }
        return newEntry;
    }

    public void clear() {
        this.entries = new MapEntryImpl[8];
        this.count = 0;
    }

    public MapEntryImpl getEntry(Object key, int hash, Equality comparator) {
        return this.entries[this.indexOfKey(key, hash, comparator)];
    }

    public MapEntryImpl removeEntry(Object key, int hash, Equality comparator) {
        MapEntryImpl entry;
        int i = this.indexOfKey(key, hash, comparator);
        MapEntryImpl oldEntry = this.entries[i];
        if (oldEntry == null) {
            return null;
        }
        this.entries[i] = null;
        while ((entry = this.entries[i = i + 1 & this.entries.length - 1]) != null) {
            int correctIndex = this.indexOfKey(entry.key, entry.hash, comparator);
            if (correctIndex == i) continue;
            this.entries[correctIndex] = this.entries[i];
            this.entries[i] = null;
        }
        if (--this.count << 3 <= this.entries.length && this.entries.length > 8) {
            this.resize(this.entries.length >> 1);
        }
        return oldEntry;
    }

    private int indexOfKey(Object key, int hash, Equality comparator) {
        int mask = this.entries.length - 1;
        int i = hash >> this.shift & mask;
        MapEntryImpl entry;
        while ((entry = this.entries[i]) != null) {
            if (entry.hash == hash && comparator.areEqual(key, entry.key)) {
                return i;
            }
            i = i + 1 & mask;
        }
        return i;
    }

    private void resize(int newCapacity) {
        MapEntryImpl[] newEntries = new MapEntryImpl[newCapacity];
        int newMask = newEntries.length - 1;
        for (MapEntryImpl entry : this.entries) {
            if (entry == null) continue;
            int newIndex = entry.hash & newMask;
            while (newEntries[newIndex] != null) {
                newIndex = newIndex + 1 & newMask;
            }
            newEntries[newIndex] = entry;
        }
        this.entries = newEntries;
    }
}

