/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javolution.util.function.Equality;
import javolution.util.internal.collection.CollectionView;
import javolution.util.internal.table.ReversedTableImpl;
import javolution.util.internal.table.SubTableImpl;
import javolution.util.internal.table.TableIteratorImpl;
import javolution.util.service.TableService;

public abstract class TableView<E>
extends CollectionView<E>
implements TableService<E> {
    private static final long serialVersionUID = 1536L;

    public TableView(TableService<E> target) {
        super(target);
    }

    @Override
    public abstract void add(int var1, E var2);

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.subList(index, index).addAll(c);
    }

    @Override
    public void addFirst(E element) {
        this.add(0, element);
    }

    @Override
    public void addLast(E element) {
        this.add(this.size(), element);
    }

    @Override
    public abstract void clear();

    @Override
    public final boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ReversedTableImpl(this).iterator();
    }

    @Override
    public final E element() {
        return this.getFirst();
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E getFirst() {
        if (this.size() == 0) {
            this.emptyError();
        }
        return this.get(0);
    }

    @Override
    public E getLast() {
        if (this.size() == 0) {
            this.emptyError();
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object o) {
        Equality cmp = this.comparator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!cmp.areEqual(o, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public int lastIndexOf(Object o) {
        Equality cmp = this.comparator();
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!cmp.areEqual(o, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new TableIteratorImpl(this, index);
    }

    @Override
    public final boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public final boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public final boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public final E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        return this.size() == 0 ? null : (E)this.getFirst();
    }

    @Override
    public E peekLast() {
        return this.size() == 0 ? null : (E)this.getLast();
    }

    @Override
    public final E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollFirst() {
        return this.size() == 0 ? null : (E)this.removeFirst();
    }

    @Override
    public E pollLast() {
        return this.size() == 0 ? null : (E)this.removeLast();
    }

    @Override
    public final E pop() {
        return this.removeFirst();
    }

    @Override
    public final void push(E e) {
        this.addFirst(e);
    }

    @Override
    public final E remove() {
        return this.removeFirst();
    }

    @Override
    public abstract E remove(int var1);

    @Override
    public final boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public E removeFirst() {
        if (this.size() == 0) {
            this.emptyError();
        }
        return this.remove(0);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public E removeLast() {
        if (this.size() == 0) {
            this.emptyError();
        }
        return this.remove(this.size() - 1);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        int i = this.lastIndexOf(o);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public abstract E set(int var1, E var2);

    @Override
    public abstract int size();

    @Override
    public TableService<E>[] split(int n, boolean updateable) {
        return SubTableImpl.splitOf(this, n, updateable);
    }

    @Override
    public TableService<E> subList(int fromIndex, int toIndex) {
        return new SubTableImpl(this, fromIndex, toIndex);
    }

    protected void emptyError() {
        throw new NoSuchElementException("Empty Table");
    }

    protected void indexError(int index) {
        throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size());
    }

    @Override
    protected TableService<E> target() {
        return (TableService)super.target();
    }
}

