/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.marmotta.commons.http.ContentType;
import org.openrdf.query.resultio.QueryResultFormat;

public class MarmottaHttpUtils {
    public static List<ContentType> parseAcceptHeader(String header) {
        String[] components = header.split(",");
        ArrayList<ContentType> contentTypes = new ArrayList<ContentType>(components.length);
        for (String c : components) {
            ContentType type;
            String[] mt = c.split(";");
            String[] tst = mt[0].split("/");
            if (tst.length != 2 || (type = MarmottaHttpUtils.parseContentType(c)) == null) continue;
            contentTypes.add(type);
        }
        Collections.sort(contentTypes);
        return contentTypes;
    }

    public static List<ContentType> parseStringList(Collection<String> types) {
        ArrayList<ContentType> contentTypes = new ArrayList<ContentType>(types.size());
        for (String c : types) {
            ContentType type = MarmottaHttpUtils.parseContentType(c);
            if (type == null) continue;
            contentTypes.add(type);
        }
        return contentTypes;
    }

    public static List<ContentType> parseQueryResultFormatList(Collection<? extends QueryResultFormat> types) {
        ArrayList<ContentType> contentTypes = new ArrayList<ContentType>();
        for (QueryResultFormat queryResultFormat : types) {
            if (!queryResultFormat.hasCharset()) continue;
            for (String nextMimeType : queryResultFormat.getMIMETypes()) {
                if (nextMimeType.equals("application/xml")) continue;
                ContentType type = new ContentType(MarmottaHttpUtils.parseContentType(nextMimeType).getType(), MarmottaHttpUtils.parseContentType(nextMimeType).getSubtype(), queryResultFormat.getCharset());
                if (queryResultFormat.getDefaultMIMEType().equals(nextMimeType)) {
                    type.setParameter("q", "1.0");
                } else {
                    type.setParameter("q", "0.5");
                }
                contentTypes.add(type);
            }
        }
        return contentTypes;
    }

    public static ContentType parseContentType(String c) {
        if (StringUtils.isBlank((CharSequence)c)) {
            return null;
        }
        String[] mt = c.split(";");
        String[] tst = mt[0].split("/");
        if (tst.length == 2) {
            ContentType type = new ContentType(tst[0], tst[1]);
            for (int i = 1; i < mt.length; ++i) {
                String[] kv = mt[i].split("=");
                if (kv.length != 2) continue;
                type.setParameter(kv[0].trim(), kv[1].trim());
                if (!"charset".equalsIgnoreCase(kv[0].trim())) continue;
                type.setCharset(Charset.forName(kv[1].trim()));
            }
            return type;
        }
        return null;
    }

    public static ContentType bestContentType(List<ContentType> offeredTypes, List<ContentType> requestedTypes) {
        for (ContentType requested : requestedTypes) {
            for (ContentType offered : offeredTypes) {
                if (!requested.matches(offered)) continue;
                return offered;
            }
        }
        for (ContentType requested : requestedTypes) {
            for (ContentType offered : offeredTypes) {
                if (!requested.matchesSubtype(offered)) continue;
                return offered;
            }
        }
        for (ContentType requested : requestedTypes) {
            for (ContentType offered : offeredTypes) {
                if (!requested.matchesWildcard(offered)) continue;
                return offered;
            }
        }
        return null;
    }

    public static ContentType performContentNegotiation(String accept, Collection<String> producedContentTypes) {
        return MarmottaHttpUtils.performContentNegotiation(accept, MarmottaHttpUtils.parseStringList(producedContentTypes));
    }

    public static ContentType performContentNegotiation(String accept, List<ContentType> producedContentTypes) {
        List<ContentType> acceptedContentTypes = MarmottaHttpUtils.parseAcceptHeader(StringUtils.defaultString((String)accept, (String)""));
        return MarmottaHttpUtils.bestContentType(producedContentTypes, acceptedContentTypes);
    }
}

