/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.model;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Map;
import java.util.Set;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.function.Equality;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class StatementCommons {
    private static final Equivalence<Statement> TRIPLE_EQUIVALENCE = new Equivalence<Statement>(){

        protected boolean doEquivalent(Statement a, Statement b) {
            if (a == b) {
                return true;
            }
            if (!Objects.equal((Object)a.getSubject(), (Object)b.getSubject())) {
                return false;
            }
            if (!Objects.equal((Object)a.getPredicate(), (Object)b.getPredicate())) {
                return false;
            }
            return Objects.equal((Object)a.getObject(), (Object)b.getObject());
        }

        protected int doHash(Statement statement) {
            return Objects.hashCode((Object[])new Object[]{statement.getSubject(), statement.getPredicate(), statement.getObject()});
        }

        public boolean equals(Object obj) {
            return ((Object)((Object)this)).getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    };
    private static final Equivalence<Statement> QUADRUPLE_EQUIVALENCE = new Equivalence<Statement>(){

        protected boolean doEquivalent(Statement a, Statement b) {
            if (a == b) {
                return true;
            }
            if (!Objects.equal((Object)a.getSubject(), (Object)b.getSubject())) {
                return false;
            }
            if (!Objects.equal((Object)a.getPredicate(), (Object)b.getPredicate())) {
                return false;
            }
            if (!Objects.equal((Object)a.getObject(), (Object)b.getObject())) {
                return false;
            }
            return Objects.equal((Object)a.getContext(), (Object)b.getContext());
        }

        protected int doHash(Statement statement) {
            return Objects.hashCode((Object[])new Object[]{statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()});
        }

        public boolean equals(Object obj) {
            return ((Object)((Object)this)).getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    };

    public static Equivalence<Statement> tripleEquivalence() {
        return TRIPLE_EQUIVALENCE;
    }

    public static Equivalence<Statement> quadrupleEquivalence() {
        return QUADRUPLE_EQUIVALENCE;
    }

    public static <T extends Statement> Set<T> newTripleSet() {
        return new FastSet<Statement>(StatementCommons.equivalenceEquality(StatementCommons.tripleEquivalence()));
    }

    public static <T extends Statement> Set<T> newQuadrupleSet() {
        return new FastSet<Statement>(StatementCommons.equivalenceEquality(StatementCommons.quadrupleEquivalence()));
    }

    public static <K extends Statement, V> Map<K, V> newTripleMap() {
        return new FastMap(StatementCommons.equivalenceEquality(StatementCommons.tripleEquivalence()));
    }

    public static <K extends Statement, V> Map<K, V> newQuadrupleMap() {
        return new FastMap(StatementCommons.equivalenceEquality(StatementCommons.quadrupleEquivalence()));
    }

    private static <E> Equality<E> equivalenceEquality(final Equivalence<E> equivalence) {
        return new Equality<E>(){
            private static final long serialVersionUID = 1L;

            @Override
            public int hashCodeOf(E object) {
                return equivalence.hash(object);
            }

            @Override
            public boolean areEqual(E left, E right) {
                return equivalence.equivalent(left, right);
            }

            @Override
            public int compare(E left, E right) {
                return equivalence.hash(left) - equivalence.hash(right);
            }

            public int hashCode() {
                return equivalence.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return obj.hashCode() == this.hashCode();
            }
        };
    }

    public static class TripleEquality
    implements Function<Statement, Statement> {
        public Statement apply(final Statement input) {
            return new Statement(){

                public Resource getSubject() {
                    return input.getSubject();
                }

                public URI getPredicate() {
                    return input.getPredicate();
                }

                public Value getObject() {
                    return input.getObject();
                }

                public Resource getContext() {
                    return input.getContext();
                }

                public int hashCode() {
                    return TRIPLE_EQUIVALENCE.hash((Object)input);
                }

                public boolean equals(Object obj) {
                    return TRIPLE_EQUIVALENCE.equivalent((Object)input, (Object)((Statement)obj));
                }

                public String toString() {
                    return input.toString();
                }
            };
        }
    }
}

