/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.api.endpoint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.marmotta.commons.http.ContentType;
import org.apache.marmotta.commons.http.MarmottaHttpUtils;

public class Endpoint
implements Comparable<Endpoint> {
    public static final int PRIORITY_HIGH = 3;
    public static final int PRIORITY_MEDIUM = 2;
    public static final int PRIORITY_LOW = 1;
    private String name;
    private String type;
    public static final String REGEX_INDICATOR = "~";
    private String uriPattern;
    private Pattern uriPatternCompiled = null;
    private boolean active = true;
    private int priority = 2;
    private String endpointUrl;
    private Set<ContentType> contentTypes = new HashSet<ContentType>();
    private Long defaultExpiry;
    private Map<String, String> properties = new HashMap<String, String>();

    public Endpoint() {
    }

    public Endpoint(String name, String type, String uriPattern, String endpointUrl, Long defaultExpiry) {
        this();
        this.name = name;
        this.type = type;
        this.uriPattern = uriPattern;
        this.endpointUrl = endpointUrl;
        this.defaultExpiry = defaultExpiry;
    }

    public Endpoint(String name, String type, String uriPattern, String endpointUrl, String contentType, Long defaultExpiry) {
        this(name, type, uriPattern, endpointUrl, defaultExpiry);
        this.contentTypes = new HashSet<ContentType>(MarmottaHttpUtils.parseAcceptHeader(contentType));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
        this.uriPatternCompiled = null;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public Set<ContentType> getContentTypes() {
        return this.contentTypes;
    }

    public void addContentType(ContentType type) {
        this.contentTypes.add(type);
    }

    public void setContentTypes(Set<ContentType> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public Long getDefaultExpiry() {
        return this.defaultExpiry;
    }

    public void setDefaultExpiry(Long defaultExpiry) {
        this.defaultExpiry = defaultExpiry;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Pattern getUriPatternCompiled() {
        if (this.uriPatternCompiled == null) {
            try {
                this.uriPatternCompiled = this.uriPattern.startsWith(REGEX_INDICATOR) ? Pattern.compile(this.uriPattern.substring(REGEX_INDICATOR.length())) : Pattern.compile(this.uriPattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return this.uriPatternCompiled;
    }

    public boolean handles(String uri) {
        if (this.isActive() && this.getUriPatternCompiled() != null) {
            return this.getUriPatternCompiled().matcher(uri).find();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        if (this.name != null ? !this.name.equals(endpoint.name) : endpoint.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(endpoint.type) : endpoint.type != null) {
            return false;
        }
        return !(this.uriPattern != null ? !this.uriPattern.equals(endpoint.uriPattern) : endpoint.uriPattern != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.uriPattern != null ? this.uriPattern.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Endpoint o) {
        if (this.getPriority() > o.getPriority()) {
            return -1;
        }
        if (this.getPriority() < o.getPriority()) {
            return 1;
        }
        return 0;
    }
}

