/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.model;

import java.util.Date;
import javolution.util.function.Predicate;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.marmotta.commons.sesame.model.ModelCommons;
import org.openrdf.model.Model;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;

public class ClientResponse {
    private static final int DEFAULT_HTTP_CODE = 200;
    private static final int DEFAULT_EXPIRATION_IN_DAYS = 7;
    private int httpStatus;
    private Model data;
    private Date expires;

    @Deprecated
    public ClientResponse(int httpStatus, Repository triples) {
        this.expires = DateUtils.addDays((Date)new Date(), (int)7);
        this.httpStatus = httpStatus;
        try {
            this.data = ModelCommons.asModel(triples, new Predicate[0]);
        }
        catch (RepositoryException e) {
            this.data = new TreeModel();
        }
    }

    public ClientResponse(int httpStatus, Model triples) {
        this.data = triples;
        this.expires = DateUtils.addDays((Date)new Date(), (int)7);
        this.httpStatus = httpStatus;
    }

    @Deprecated
    public Repository getTriples() {
        try {
            return ModelCommons.asRepository(this.data);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public Model getData() {
        return this.data;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = new Date(expires.getTime());
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }
}

