/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javolution.lang.Immutable;
import javolution.lang.Parallelizable;
import javolution.lang.Realtime;
import javolution.util.FastCollection;
import javolution.util.FastSet;
import javolution.util.function.Consumer;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.internal.map.AtomicMapImpl;
import javolution.util.internal.map.FastMapImpl;
import javolution.util.internal.map.SequentialMapImpl;
import javolution.util.internal.map.SharedMapImpl;
import javolution.util.internal.map.UnmodifiableMapImpl;
import javolution.util.service.CollectionService;
import javolution.util.service.MapService;

@Realtime
public class FastMap<K, V>
implements Map<K, V>,
ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1536L;
    private final MapService<K, V> service;

    public FastMap() {
        this(Equalities.STANDARD);
    }

    public FastMap(Equality<? super K> keyEquality) {
        this(keyEquality, Equalities.STANDARD);
    }

    public FastMap(Equality<? super K> keyEquality, Equality<? super V> valueEquality) {
        this.service = new FastMapImpl<K, V>(keyEquality, valueEquality);
    }

    protected FastMap(MapService<K, V> service) {
        this.service = service;
    }

    @Parallelizable(mutexFree=true, comment="Except for write operations, all read operations are mutex-free.")
    public FastMap<K, V> atomic() {
        return new FastMap<K, V>(new AtomicMapImpl<K, V>(this.service));
    }

    @Parallelizable(mutexFree=false, comment="Use multiple-readers/single-writer lock.")
    public FastMap<K, V> shared() {
        return new FastMap<K, V>(new SharedMapImpl<K, V>(this.service));
    }

    public FastMap<K, V> sequential() {
        return new FastMap<K, V>(new SequentialMapImpl<K, V>(this.service));
    }

    public FastMap<K, V> unmodifiable() {
        return new FastMap<K, V>(new UnmodifiableMapImpl<K, V>(this.service));
    }

    @Override
    public FastSet<K> keySet() {
        return new FastSet<K>(this.service.keySet());
    }

    @Override
    public FastCollection<V> values() {
        return new FastCollection<V>(){
            private static final long serialVersionUID = 1536L;
            private final CollectionService<V> serviceValues;
            {
                this.serviceValues = FastMap.this.service.values();
            }

            @Override
            protected CollectionService<V> service() {
                return this.serviceValues;
            }
        };
    }

    @Override
    public FastSet<Map.Entry<K, V>> entrySet() {
        return new FastSet<Map.Entry<K, V>>(this.service.entrySet());
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public void perform(Consumer<? extends Map<K, V>> action) {
        this.service().perform(action, this.service());
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public void update(Consumer<? extends Map<K, V>> action) {
        this.service().update(action, this.service());
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public int size() {
        return this.service.size();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean isEmpty() {
        return this.service.isEmpty();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean containsKey(Object key) {
        return this.service.containsKey(key);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public boolean containsValue(Object value) {
        return this.service.containsValue(value);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public V get(Object key) {
        return this.service.get(key);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public V put(K key, V value) {
        return this.service.put(key, value);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public void putAll(Map<? extends K, ? extends V> map) {
        this.service.putAll(map);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public V remove(Object key) {
        return this.service.remove(key);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public void clear() {
        this.service.clear();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public V putIfAbsent(K key, V value) {
        return this.service.putIfAbsent(key, value);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean remove(Object key, Object value) {
        return this.service.remove(key, value);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean replace(K key, V oldValue, V newValue) {
        return this.service.replace(key, oldValue, newValue);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public V replace(K key, V value) {
        return this.service.replace(key, value);
    }

    public FastMap<K, V> putAll(FastMap<? extends K, ? extends V> that) {
        this.putAll((Map<? extends K, ? extends V>)that);
        return this;
    }

    public <T extends Map<K, V>> Immutable<T> toImmutable() {
        return new Immutable<T>(){
            final T value;
            {
                this.value = FastMap.this.unmodifiable();
            }

            @Override
            public T value() {
                return this.value;
            }
        };
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public String toString() {
        return ((FastCollection)((Object)this.entrySet())).toString();
    }

    protected MapService<K, V> service() {
        return this.service;
    }
}

