/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Collection;
import java.util.Iterator;
import javolution.util.function.Consumer;
import javolution.util.function.Equality;
import javolution.util.internal.ReadWriteLockImpl;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

public class SharedCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;
    protected ReadWriteLockImpl lock;

    public SharedCollectionImpl(CollectionService<E> target) {
        this(target, new ReadWriteLockImpl());
    }

    public SharedCollectionImpl(CollectionService<E> target, ReadWriteLockImpl lock) {
        super(target);
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E element) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().add(element);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().addAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.writeLock.lock();
        try {
            this.target().clear();
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedCollectionImpl<E> clone() {
        this.lock.readLock.lock();
        try {
            SharedCollectionImpl copy = (SharedCollectionImpl)super.clone();
            copy.lock = new ReadWriteLockImpl();
            SharedCollectionImpl sharedCollectionImpl = copy;
            return sharedCollectionImpl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.lock.readLock.lock();
        try {
            boolean bl = this.target().contains(o);
            return bl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        this.lock.readLock.lock();
        try {
            boolean bl = this.target().containsAll(c);
            return bl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        this.lock.readLock.lock();
        try {
            boolean bl = this.target().equals(o);
            return bl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.lock.readLock.lock();
        try {
            int n = this.target().hashCode();
            return n;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.lock.readLock.lock();
        try {
            boolean bl = this.target().isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Consumer<CollectionService<E>> action, CollectionService<E> view) {
        this.lock.readLock.lock();
        try {
            this.target().perform(action, view);
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().remove(o);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().removeAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().retainAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.readLock.lock();
        try {
            int n = this.target().size();
            return n;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectionService<E>[] split(int n, boolean updateable) {
        CollectionService[] tmp;
        this.lock.readLock.lock();
        try {
            tmp = (CollectionService[])this.target().split(n, updateable);
        }
        finally {
            this.lock.readLock.unlock();
        }
        CollectionService[] result = new CollectionService[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            result[i] = new SharedCollectionImpl<E>(tmp[i], this.lock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.readLock.lock();
        try {
            Object[] objectArray = this.target().toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.readLock.lock();
        try {
            T[] TArray = this.target().toArray(a);
            return TArray;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    protected CollectionService<E> cloneTarget() {
        try {
            return this.target().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Cannot happen since target is Cloneable.");
        }
    }

    private class IteratorImpl
    implements Iterator<E> {
        private E next;
        private final Iterator<E> targetIterator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IteratorImpl() {
            SharedCollectionImpl.this.lock.readLock.lock();
            try {
                this.targetIterator = SharedCollectionImpl.this.cloneTarget().iterator();
            }
            finally {
                SharedCollectionImpl.this.lock.readLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.targetIterator.hasNext();
        }

        @Override
        public E next() {
            this.next = this.targetIterator.next();
            return this.next;
        }

        @Override
        public void remove() {
            if (this.next == null) {
                throw new IllegalStateException();
            }
            SharedCollectionImpl.this.remove(this.next);
            this.next = null;
        }
    }
}

