/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.set.sorted;

import javolution.util.internal.ReadWriteLockImpl;
import javolution.util.internal.set.SharedSetImpl;
import javolution.util.internal.set.sorted.SubSortedSetImpl;
import javolution.util.service.SetService;
import javolution.util.service.SortedSetService;

public class SharedSortedSetImpl<E>
extends SharedSetImpl<E>
implements SortedSetService<E> {
    private static final long serialVersionUID = 1536L;

    public SharedSortedSetImpl(SetService<E> target) {
        super(target);
    }

    public SharedSortedSetImpl(SortedSetService<E> target, ReadWriteLockImpl lock) {
        super(target, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E first() {
        this.lock.readLock.lock();
        try {
            Object e = this.target().first();
            return e;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public SortedSetService<E> headSet(E toElement) {
        return new SubSortedSetImpl<Object>(this, null, toElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E last() {
        this.lock.readLock.lock();
        try {
            Object e = this.target().last();
            return e;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetService<E>[] split(int n, boolean updateable) {
        SortedSetService<E>[] tmp;
        this.lock.readLock.lock();
        try {
            tmp = this.target().split(n, updateable);
        }
        finally {
            this.lock.readLock.unlock();
        }
        SortedSetService[] result = new SortedSetService[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            result[i] = new SharedSortedSetImpl(tmp[i], this.lock);
        }
        return result;
    }

    @Override
    public SortedSetService<E> subSet(E fromElement, E toElement) {
        return new SubSortedSetImpl<E>(this, fromElement, toElement);
    }

    @Override
    public SortedSetService<E> tailSet(E fromElement) {
        return new SubSortedSetImpl<Object>(this, fromElement, null);
    }

    @Override
    protected SortedSetService<E> target() {
        return (SortedSetService)super.target();
    }
}

