/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.model;

import java.util.HashSet;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;

public class ClientConfiguration {
    private int socketTimeout = 60000;
    private int connectionTimeout = 10000;
    private int maxParallelRequests = 10;
    private long defaultExpiry = 86400L;
    private long minimumExpiry = 30L;
    private Set<String> excludeUris = new HashSet<String>();
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();
    private Set<DataProvider> providers = new HashSet<DataProvider>();
    private HttpClient httpClient = null;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getMaxParallelRequests() {
        return this.maxParallelRequests;
    }

    public void setMaxParallelRequests(int maxParallelRequests) {
        this.maxParallelRequests = maxParallelRequests;
    }

    public long getDefaultExpiry() {
        return this.defaultExpiry;
    }

    public void setDefaultExpiry(long defaultExpiry) {
        this.defaultExpiry = defaultExpiry;
    }

    public long getMinimumExpiry() {
        return this.minimumExpiry;
    }

    public void setMinimumExpiry(long minimumExpiry) {
        this.minimumExpiry = minimumExpiry;
    }

    public void addExcludeUri(String uriPrefix) {
        this.excludeUris.add(uriPrefix);
    }

    public Set<String> getExcludeUris() {
        return this.excludeUris;
    }

    public void setExcludeUris(Set<String> excludeUris) {
        this.excludeUris = excludeUris;
    }

    public boolean isExcludedUri(String uri) {
        for (String prefix : this.excludeUris) {
            if (!uri.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void addProvider(DataProvider provider) {
        this.providers.add(provider);
    }

    public Set<DataProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(Set<DataProvider> providers) {
        this.providers = providers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

