/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.selectors;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;

public class RecursivePathSelector<Node>
implements NodeSelector<Node> {
    private final NodeSelector<Node> delegate;
    private final int minRecursions;
    private final int maxRecursions;

    public RecursivePathSelector(NodeSelector<Node> delegate, int min, int max) {
        this.delegate = delegate;
        this.minRecursions = min;
        this.maxRecursions = max;
    }

    @Override
    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        LinkedList<Node> result = new LinkedList<Node>();
        if (this.minRecursions <= 0) {
            result.add(context);
        }
        this.subSelect(context, 0, rdfBackend, result, path, resultPaths);
        return result;
    }

    private void subSelect(Node currentContext, int depth, RDFBackend<Node> rdfBackend, List<Node> resultList, List<Node> path, Map<Node, List<Node>> resultPaths) {
        Collection<Node> nextNodes = this.delegate.select(rdfBackend, currentContext, path, resultPaths);
        ++depth;
        for (Node n : nextNodes) {
            if (resultList.contains(n)) continue;
            if (depth >= this.minRecursions) {
                resultList.add(n);
            }
            if (depth >= this.maxRecursions) continue;
            if (path != null && resultPaths != null) {
                this.subSelect(n, depth, rdfBackend, resultList, (List<Node>)new ImmutableList.Builder().addAll(path).add(currentContext).build(), resultPaths);
                continue;
            }
            this.subSelect(n, depth, rdfBackend, resultList, null, resultPaths);
        }
    }

    @Override
    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        if (this.maxRecursions != Integer.MAX_VALUE) {
            if (this.minRecursions <= 0) {
                return String.format("(%s){,%d}", this.delegate.getPathExpression(rdfBackend), this.maxRecursions);
            }
            return String.format("(%s){%d,%d}", this.delegate.getPathExpression(rdfBackend), this.minRecursions, this.maxRecursions);
        }
        if (this.minRecursions <= 0) {
            return String.format("(%s)*", this.delegate.getPathExpression(rdfBackend));
        }
        if (this.minRecursions == 1) {
            return String.format("(%s)+", this.delegate.getPathExpression(rdfBackend));
        }
        return String.format("(%s){%d,}", this.delegate.getPathExpression(rdfBackend), this.minRecursions);
    }

    @Override
    public String getName(NodeBackend<Node> nodeRDFBackend) {
        return this.delegate.getName(nodeRDFBackend);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorStared(NodeSelector<N> delegate) {
        return new RecursivePathSelector<N>(delegate, 0, Integer.MAX_VALUE);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorPlused(NodeSelector<N> delegate) {
        return new RecursivePathSelector<N>(delegate, 1, Integer.MAX_VALUE);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorMinBound(NodeSelector<N> delegate, int minBound) {
        return new RecursivePathSelector<N>(delegate, minBound, Integer.MAX_VALUE);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorMaxBound(NodeSelector<N> delegate, int maxBound) {
        return new RecursivePathSelector<N>(delegate, 0, maxBound);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorMinMaxBound(NodeSelector<N> delegate, int minBound, int maxBound) {
        return new RecursivePathSelector<N>(delegate, minBound, maxBound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursivePathSelector that = (RecursivePathSelector)o;
        if (this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null) {
            return false;
        }
        return this.minRecursions == that.minRecursions && this.maxRecursions == that.maxRecursions;
    }

    public int hashCode() {
        int hash = this.delegate != null ? this.delegate.hashCode() : 0;
        hash = hash * 31 * 31 + this.minRecursions * 31 + this.maxRecursions;
        return hash;
    }
}

