/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.tests;

import java.util.Collection;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;
import org.apache.marmotta.ldpath.api.tests.NodeTest;

public class PathTest<Node>
extends NodeTest<Node> {
    private NodeSelector<Node> path;

    public PathTest(NodeSelector<Node> path) {
        this.path = path;
    }

    @Override
    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node candidate) throws IllegalArgumentException {
        if (rdfBackend.isURI(candidate) || rdfBackend.isBlank(candidate)) {
            Collection<Node> testResult = this.path.select(rdfBackend, candidate, null, null);
            return testResult.size() > 0;
        }
        return false;
    }

    @Override
    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        return this.path.getPathExpression(rdfBackend);
    }

    @Override
    public String getSignature() {
        return "nodes :: NodeList -> Boolean";
    }

    @Override
    public String getDescription() {
        return "Tests whether the node list is non-empty";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathTest pathTest = (PathTest)o;
        return !(this.path != null ? !this.path.equals(pathTest.path) : pathTest.path != null);
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }
}

