/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.http;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import org.apache.marmotta.commons.sesame.repository.ResourceUtils;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class ETagGenerator {
    public static String getETag(RepositoryConnection conn, String uri) throws RepositoryException {
        URI resource = ResourceUtils.getUriResource(conn, uri);
        return ETagGenerator.getETag(conn, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getETag(RepositoryConnection conn, URI resource) throws RepositoryException {
        if (resource == null) {
            return "";
        }
        Hasher hasher = ETagGenerator.buildHasher();
        hasher.putString((CharSequence)resource.stringValue(), Charset.defaultCharset());
        try (RepositoryResult outgoing = conn.getStatements((Resource)resource, null, null, true, new Resource[0]);){
            while (outgoing.hasNext()) {
                Statement statement = (Statement)outgoing.next();
                hasher.putString((CharSequence)statement.getPredicate().stringValue(), Charset.defaultCharset());
                hasher.putString((CharSequence)statement.getObject().stringValue(), Charset.defaultCharset());
            }
        }
        try (RepositoryResult incoming = conn.getStatements(null, null, (Value)resource, true, new Resource[0]);){
            while (incoming.hasNext()) {
                Statement statement = (Statement)incoming.next();
                hasher.putString((CharSequence)statement.getSubject().stringValue(), Charset.defaultCharset());
                hasher.putString((CharSequence)statement.getPredicate().stringValue(), Charset.defaultCharset());
            }
        }
        return hasher.hash().toString();
    }

    public static String getWeakETag(RepositoryConnection conn, String resource) throws RepositoryException {
        if (resource.startsWith("http://")) {
            return ETagGenerator.getWeakETag(conn, (Resource)ResourceUtils.getUriResource(conn, resource));
        }
        return ETagGenerator.getWeakETag(conn, (Resource)ResourceUtils.getAnonResource(conn, resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWeakETag(RepositoryConnection conn, Resource resource) throws RepositoryException {
        if (resource == null) {
            return "";
        }
        Hasher hasher = ETagGenerator.buildHasher();
        hasher.putString((CharSequence)resource.stringValue(), Charset.defaultCharset());
        try (RepositoryResult statements = conn.getStatements(resource, null, null, true, new Resource[0]);){
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                hasher.putString((CharSequence)statement.getPredicate().stringValue(), Charset.defaultCharset());
                hasher.putString((CharSequence)statement.getObject().stringValue(), Charset.defaultCharset());
            }
        }
        return hasher.hash().toString();
    }

    private static Hasher buildHasher() {
        HashFunction function = Hashing.goodFastHash((int)16);
        Hasher hasher = function.newHasher();
        return hasher;
    }
}

